/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.windows.state;

import convex.core.data.ACell;
import convex.core.data.ARecord;
import convex.core.data.Keyword;
import convex.core.data.MapEntry;
import convex.core.data.MapLeaf;
import convex.core.util.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class StateTreePanel
extends JPanel {
    private final ACell state;
    private static final TreeWillExpandListener expandListener = new TreeWillExpandListener(){

        @Override
        public void treeWillExpand(TreeExpansionEvent tee) throws ExpandVetoException {
            TreePath path = tee.getPath();
            Node tn = (Node)path.getLastPathComponent();
            tn.loadChildren();
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent tee) throws ExpandVetoException {
        }
    };

    public StateTreePanel(ACell state) {
        this.state = state;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(600, 400));
        Node tNode = new Node(this.state);
        tNode.setAllowsChildren(true);
        tNode.loadChildren();
        DefaultTreeModel tModel = new DefaultTreeModel(tNode);
        JTree tree = new JTree(tModel);
        tree.addTreeWillExpandListener(expandListener);
        tree.expandPath(new TreePath(tNode.getPath()));
        this.add((Component)tree, "Center");
    }

    private static class Node
    extends DefaultMutableTreeNode {
        private final boolean container;
        private boolean loaded = false;
        private final String name;

        public Node(String name, ACell val) {
            super(val);
            this.name = name;
            this.container = Utils.refCount(val) > 0;
        }

        public Node(ACell val) {
            this(null, val);
        }

        @Override
        public boolean isLeaf() {
            return !this.container;
        }

        private static String getString(Object val) {
            if (val instanceof ACell) {
                ACell r = (ACell)val;
                return r.getClass().getSimpleName() + " [" + r.getHash().toHexString(6) + "...]";
            }
            return Utils.getClassName(val);
        }

        @Override
        public String toString() {
            if (this.name != null) {
                return this.name;
            }
            return Node.getString(this.userObject);
        }

        public void loadChildren() {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            if (this.userObject instanceof ARecord) {
                ARecord r = (ARecord)this.userObject;
                for (Keyword k : r.getKeys()) {
                    ACell c = r.get(k);
                    this.add(new Node(k + " = " + Node.getString(c), c));
                }
                return;
            }
            if (this.userObject instanceof MapLeaf) {
                MapLeaf m = (MapLeaf)this.userObject;
                for (Map.Entry oe : m.entrySet()) {
                    MapEntry e = (MapEntry)oe;
                    Object c = e.getValue();
                    this.add(new Node(Node.getString(e.getKey()) + " = " + Node.getString(c), (ACell)c));
                }
                return;
            }
            if (!this.container) {
                return;
            }
            ACell rc = (ACell)this.userObject;
            int n = rc.getRefCount();
            for (int i = 0; i < n; ++i) {
                Object child = rc.getRef(i).getValue();
                this.add(new Node((ACell)child));
            }
        }
    }
}

