/*
 * Decompiled with CFR 0.152.
 */
package convex.core.store;

import convex.core.data.ACell;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.store.AStore;
import convex.core.util.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStore
extends AStore {
    public static final MemoryStore DEFAULT = new MemoryStore();
    private static final Logger log = LoggerFactory.getLogger(MemoryStore.class.getName());
    private final HashMap<Hash, Ref<ACell>> hashRefs = new HashMap();
    private Hash rootHash;

    @Override
    public <T extends ACell> Ref<T> refForHash(Hash hash) {
        Ref<ACell> ref = this.hashRefs.get(hash);
        return ref;
    }

    @Override
    public <T extends ACell> Ref<T> storeRef(Ref<T> r2, int status, Consumer<Ref<ACell>> noveltyHandler) {
        return this.persistRef(r2, noveltyHandler, status, false);
    }

    @Override
    public <T extends ACell> Ref<T> storeTopRef(Ref<T> ref, int status, Consumer<Ref<ACell>> noveltyHandler) {
        return this.persistRef(ref, noveltyHandler, status, true);
    }

    public <T extends ACell> Ref<T> persistRef(Ref<T> ref, Consumer<Ref<ACell>> noveltyHandler, int requiredStatus, boolean topLevel) {
        Ref<T> existing;
        T o = (ref = ref.toDirect()).getValue();
        if (o == null) {
            return Ref.NULL_VALUE;
        }
        Object cell = o;
        boolean embedded = ((ACell)cell).isEmbedded();
        Hash hash = null;
        if (!embedded && (existing = this.refForHash(hash = ref.getHash())) != null) {
            if (existing.getStatus() >= requiredStatus) {
                return existing;
            }
            ref = existing;
        }
        cell = ((ACell)cell).updateRefs(r -> r.persist(noveltyHandler));
        ref = ref.withValue(cell);
        Object oTemp = cell;
        if (topLevel || !embedded) {
            Hash fHash;
            Hash hash2 = fHash = hash != null ? hash : ref.getHash();
            if (log.isTraceEnabled()) {
                log.trace("Persisting ref 0x" + fHash.toHexString() + " of class " + Utils.getClassName(oTemp) + " with store " + this);
            }
            this.hashRefs.put(fHash, ref);
            if (noveltyHandler != null) {
                noveltyHandler.accept(ref);
            }
        }
        return ref.withMinimumStatus(requiredStatus);
    }

    @Override
    public Hash getRootHash() throws IOException {
        return this.rootHash;
    }

    @Override
    public void setRootHash(Hash h) {
        this.rootHash = h;
    }

    @Override
    public void close() {
        this.hashRefs.clear();
        this.rootHash = null;
    }
}

