/*
 * Decompiled with CFR 0.152.
 */
package convex.core.init;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.Ed25519KeyPair;
import convex.core.data.Address;
import convex.core.init.Init;

public class AInitConfig {
    protected AKeyPair[] userKeyPairs;
    protected AKeyPair[] peerKeyPairs;
    public static int DEFAULT_PEER_COUNT = 8;
    public static int DEFAULT_USER_COUNT = 2;

    public int getUserCount() {
        return this.userKeyPairs.length;
    }

    public int getPeerCount() {
        return this.peerKeyPairs.length;
    }

    public AKeyPair getUserKeyPair(int index) {
        return this.userKeyPairs[index];
    }

    public AKeyPair getPeerKeyPair(int index) {
        return this.peerKeyPairs[index];
    }

    public AKeyPair[] getPeerKeyPairs() {
        return this.peerKeyPairs;
    }

    public Address getUserAddress(int index) {
        return Init.calcUserAddress(index);
    }

    public Address getPeerAddress(int index) {
        return Init.calcPeerAddress(this.getUserCount(), index);
    }

    public Address[] getPeerAddressList() {
        Address[] result = new Address[this.getPeerCount()];
        for (int index = 0; index < this.getPeerCount(); ++index) {
            result[index] = this.getPeerAddress(index);
        }
        return result;
    }

    protected AInitConfig(AKeyPair[] userKeyPairs, AKeyPair[] peerKeyPairs) {
        this.userKeyPairs = userKeyPairs;
        this.peerKeyPairs = peerKeyPairs;
    }

    public static AInitConfig create() {
        return AInitConfig.create(DEFAULT_USER_COUNT, DEFAULT_PEER_COUNT);
    }

    public static AInitConfig create(int userCount, int peerCount) {
        Ed25519KeyPair kp;
        int i;
        AKeyPair[] userKeyPairs = new Ed25519KeyPair[userCount];
        AKeyPair[] peerKeyPairs = new Ed25519KeyPair[peerCount];
        for (i = 0; i < userCount; ++i) {
            userKeyPairs[i] = kp = Ed25519KeyPair.createSeeded(543212345 + i);
        }
        for (i = 0; i < peerCount; ++i) {
            kp = Ed25519KeyPair.createSeeded(123454321 + i);
            peerKeyPairs[i] = kp;
        }
        return new AInitConfig(userKeyPairs, peerKeyPairs);
    }
}

