/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Ref;
import convex.core.data.RefDirect;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public abstract class ALongBlob
extends ABlob {
    protected static final long LENGTH = 8L;
    protected final long value;

    protected ALongBlob(long value) {
        this.value = value;
    }

    @Override
    public final long count() {
        return 8L;
    }

    @Override
    protected <R extends ACell> Ref<R> createRef() {
        RefDirect<ALongBlob> newRef;
        this.cachedRef = newRef = RefDirect.create(this, this.cachedHash(), 21);
        return newRef;
    }

    @Override
    public final String toHexString() {
        return Utils.toHexString(this.value);
    }

    @Override
    public abstract ABlob slice(long var1, long var3);

    @Override
    public abstract Blob toBlob();

    @Override
    public long commonHexPrefixLength(ABlob b) {
        return this.toBlob().commonHexPrefixLength(b);
    }

    private void checkIndex(long i) {
        if (i < 0L || i >= 8L) {
            throw new IndexOutOfBoundsException(Errors.badIndex(i));
        }
    }

    @Override
    public final byte byteAt(long i) {
        this.checkIndex(i);
        return (byte)(this.value >> (int)((8L - i - 1L) * 8L));
    }

    @Override
    public final byte getUnchecked(long i) {
        return (byte)(this.value >> (int)((8L - i - 1L) * 8L));
    }

    @Override
    public final ABlob append(ABlob d) {
        return this.toBlob().append(d);
    }

    @Override
    public abstract boolean equals(ABlob var1);

    @Override
    public final ByteBuffer writeToBuffer(ByteBuffer bb) {
        return bb.putLong(this.value);
    }

    @Override
    public final int writeToBuffer(byte[] bs, int pos) {
        Utils.writeLong(bs, pos, this.value);
        return pos + 8;
    }

    @Override
    public final Blob getChunk(long i) {
        if (i == 0L) {
            return this.toBlob();
        }
        throw new IndexOutOfBoundsException(Errors.badIndex(i));
    }

    @Override
    public final ByteBuffer getByteBuffer() {
        return this.toBlob().getByteBuffer();
    }

    @Override
    protected final long calcMemorySize() {
        return 0L;
    }

    @Override
    public final void toHexString(StringBuilder sb) {
        String s = Utils.toHexString(this.value);
        sb.append(s);
    }

    @Override
    public long hexMatchLength(ABlob b, long start, long length) {
        return this.toBlob().hexMatchLength(b, start, length);
    }

    @Override
    public final long toLong() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public final boolean equalsBytes(ABlob b) {
        if (b.count() != 8L) {
            return false;
        }
        return this.value == b.longValue();
    }

    @Override
    public abstract byte getTag();

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public boolean isCVMValue() {
        return true;
    }

    @Override
    public final int getRefCount() {
        return 0;
    }

    @Override
    public final boolean isEmbedded() {
        return true;
    }
}

