/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.Ed25519Signature;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.exceptions.BadFormatException;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public abstract class ASignature
extends ACell {
    public abstract boolean verify(ABlob var1, AccountKey var2);

    public static ASignature read(ByteBuffer bb) throws BadFormatException {
        return Ed25519Signature.read(bb);
    }

    public abstract String toHexString();

    public static ASignature fromHex(String hex) {
        byte[] bs = Utils.hexToBytes(hex);
        return Ed25519Signature.wrap(bs);
    }

    public static ASignature fromBlob(Blob sigData) {
        byte[] bs = sigData.getBytes();
        return Ed25519Signature.wrap(bs);
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public byte getTag() {
        return 34;
    }

    protected abstract ABlob getSignatureBlob();
}

