/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.SignedData;

public class MergeContext {
    private final AccountKey publicKey;
    private final State state;
    private final AKeyPair keyPair;
    private final long timestamp;

    private MergeContext(AKeyPair peerKeyPair, long mergeTimestamp, State consensusState) {
        this.state = consensusState;
        this.publicKey = peerKeyPair.getAccountKey();
        this.keyPair = peerKeyPair;
        this.timestamp = mergeTimestamp;
    }

    public static MergeContext create(AKeyPair kp, long timestamp, State s) {
        return new MergeContext(kp, timestamp, s);
    }

    public AccountKey getAccountKey() {
        return this.publicKey;
    }

    public <T extends ACell> SignedData<T> sign(T value) {
        return SignedData.create(this.keyPair, value);
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public MergeContext withTimestamp(long newTimestamp) {
        return new MergeContext(this.keyPair, newTimestamp, this.state);
    }

    public State getConsensusState() {
        return this.state;
    }
}

