/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.cli.peer.Session;
import convex.cli.peer.SessionItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Helpers {
    public static String expandTilde(String path) {
        if (path != null) {
            String userHome = System.getProperty("user.home");
            String separator = File.separator;
            String regex = separator.equals("\\") ? "\\\\" : "/";
            userHome = userHome.replaceAll(regex, "/");
            return path.replaceFirst("^~", userHome);
        }
        return null;
    }

    public static void createPath(File file) {
        File path = file.getParentFile();
        if (!path.exists()) {
            path.mkdir();
        }
    }

    public static SessionItem getSessionItem(String sessionFilename) throws IOException {
        return Helpers.getSessionItem(sessionFilename, -1);
    }

    public static SessionItem getSessionItem(String sessionFilename, int index) throws IOException {
        SessionItem item = null;
        Session session = new Session();
        Random random = new Random();
        File sessionFile = new File(sessionFilename);
        session.load(sessionFile);
        int sessionCount = session.getSize();
        if (sessionCount > 0) {
            if (index < 0) {
                index = random.nextInt(sessionCount - 1);
            }
            item = session.getItemFromIndex(index);
        }
        return item;
    }

    public static List<String> splitArrayParameter(String[] parameterValue) {
        ArrayList<String> result = new ArrayList<String>(parameterValue.length);
        for (int index = 0; index < parameterValue.length; ++index) {
            String value = parameterValue[index];
            String[] items = new String[]{value};
            if (value.indexOf(",") > 0) {
                items = value.split(",");
            }
            for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
                String newValue = items[itemIndex].trim();
                if (newValue.length() <= 0) continue;
                result.add(newValue);
            }
        }
        return result;
    }
}

