/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;

public class MemoryByteChannel
implements ByteChannel {
    private final ByteBuffer memory;
    boolean open = true;

    private MemoryByteChannel(ByteBuffer buf) {
        this.memory = buf;
    }

    public static MemoryByteChannel create(int length) {
        ByteBuffer bb = ByteBuffer.allocate(length);
        return new MemoryByteChannel(bb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws ClosedChannelException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        ByteBuffer byteBuffer = this.memory;
        synchronized (byteBuffer) {
            this.memory.flip();
            int available = this.memory.remaining();
            int numRead = Math.min(available, dst.remaining());
            this.memory.limit(numRead);
            dst.put(this.memory);
            this.memory.limit(available);
            this.memory.compact();
            return numRead;
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        ByteBuffer byteBuffer = this.memory;
        synchronized (byteBuffer) {
            ByteBuffer byteBuffer2 = src;
            synchronized (byteBuffer2) {
                int numPut = Math.min(this.memory.remaining(), src.remaining());
                int savedLimit = src.limit();
                src.limit(src.position() + numPut);
                this.memory.put(src);
                src.limit(savedLimit);
                return numPut;
            }
        }
    }
}

