/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.impl.AClosure;
import convex.core.lang.impl.Fn;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public class Lambda<T extends ACell>
extends AOp<AClosure<T>> {
    private Ref<AClosure<T>> function;

    protected Lambda(Ref<AClosure<T>> newFunction) {
        this.function = newFunction;
    }

    public static <T extends ACell> Lambda<T> create(AVector<ACell> params, AOp<T> body) {
        return new Lambda<T>(Fn.create(params, body).getRef());
    }

    public static <T extends ACell> Lambda<T> create(AClosure<T> fn) {
        return new Lambda<T>(fn.getRef());
    }

    @Override
    public <I extends ACell> Context<AClosure<T>> execute(Context<I> context) {
        Object fn = this.function.getValue().withEnvironment(context.getLocalBindings());
        return context.withResult(100L, fn);
    }

    @Override
    public int getRefCount() {
        return 1;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (i == 0) {
            return this.function;
        }
        throw new IndexOutOfBoundsException(Errors.badIndex(i));
    }

    @Override
    public Lambda<T> updateRefs(IRefFunction func) {
        Ref<AClosure<T>> newFunction = func.apply(this.function);
        if (this.function == newFunction) {
            return this;
        }
        return new Lambda<T>(newFunction);
    }

    @Override
    public void print(StringBuilder sb) {
        this.function.getValue().print(sb);
    }

    @Override
    public byte opCode() {
        return 7;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.function.encode(bs, pos);
        return pos;
    }

    public static <T extends ACell> Lambda<T> read(ByteBuffer bb) throws BadFormatException {
        Ref<AClosure<T>> function = Format.readRef(bb);
        return new Lambda<T>(function);
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        AClosure<T> fn = this.function.getValue();
        if (!(fn instanceof AClosure)) {
            throw new InvalidDataException("Lambda child must be a closure but got: " + Utils.getClassName(fn), this);
        }
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    public AClosure<T> getFunction() {
        return this.function.getValue();
    }
}

