/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.impl;

import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.Types;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.lang.impl.ADataFn;

public class SeqFn<T extends ACell>
extends ADataFn<T> {
    private ASequence<?> seq;

    public SeqFn(ASequence<?> m) {
        this.seq = m;
    }

    public static <T extends ACell> SeqFn<T> wrap(ASequence<?> m) {
        return new SeqFn<T>(m);
    }

    @Override
    public Context<T> invoke(Context context, ACell[] args) {
        int n = args.length;
        if (n == 1) {
            CVMLong key = RT.ensureLong(args[0]);
            if (key == null) {
                return context.withCastError(0, args, Types.LONG);
            }
            long ix = key.longValue();
            if (ix < 0L || ix >= this.seq.count()) {
                return context.withBoundsError(ix);
            }
            Object result = this.seq.get(key);
            return context.withResult((ACell)result);
        }
        if (n == 2) {
            CVMLong key = RT.ensureLong(args[0]);
            if (key == null) {
                return context.withCastError(0, args, Types.LONG);
            }
            long ix = key.longValue();
            if (ix < 0L || ix >= this.seq.count()) {
                return context.withResult(args[1]);
            }
            Object result = this.seq.get(key);
            return context.withResult((ACell)result);
        }
        return context.withArityError("Expected arity 1 or 2 for sequence lookup");
    }

    @Override
    public void print(StringBuilder sb) {
        this.seq.print(sb);
    }
}

