/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.impl;

import convex.core.data.ACell;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.Symbol;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AFn;
import convex.core.lang.Context;
import convex.core.lang.impl.ICoreDef;

public abstract class CoreFn<T extends ACell>
extends AFn<T>
implements ICoreDef {
    private Symbol symbol;
    private int arity;
    private boolean variadic;

    protected CoreFn(Symbol symbol) {
        this.symbol = symbol;
        this.arity = 0;
        this.variadic = true;
    }

    @Override
    public abstract Context<T> invoke(Context<ACell> var1, ACell[] var2);

    @Override
    public Symbol getSymbol() {
        return this.symbol;
    }

    @Override
    public byte getTag() {
        return -51;
    }

    protected String name() {
        return this.symbol.getName().toString();
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public CoreFn<T> toCanonical() {
        return this;
    }

    protected String minArityMessage(int minArity, int actual) {
        return this.name() + " requires minimum arity " + minArity + " but called with: " + actual;
    }

    protected String maxArityMessage(int maxArity, int actual) {
        return this.name() + " requires maximum arity " + maxArity + " but called with: " + actual;
    }

    protected String rangeArityMessage(int minArity, int maxArity, int actual) {
        return this.name() + " requires arity between " + minArity + " and " + maxArity + " but called with: " + actual;
    }

    protected String exactArityMessage(int arity, int actual) {
        return this.name() + " requires arity " + arity + " but called with: " + actual;
    }

    @Override
    public boolean hasArity(int n) {
        if (n == this.arity) {
            return true;
        }
        if (n < this.arity) {
            return false;
        }
        return this.variadic;
    }

    @Override
    public void print(StringBuilder sb) {
        this.symbol.print(sb);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -51;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.symbol.encodeRaw(bs, pos);
        return pos;
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        throw new IndexOutOfBoundsException("Bad ref index: " + i);
    }

    @Override
    public CoreFn<T> updateRefs(IRefFunction func) {
        return this;
    }

    @Override
    public int estimatedEncodingSize() {
        return 20;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.symbol.validateCell();
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }
}

