/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.core.Constants;
import convex.core.Peer;
import convex.core.Result;
import convex.core.State;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Hash;
import convex.core.data.Keywords;
import convex.core.data.PeerStatus;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.lang.RT;
import convex.core.store.Stores;
import convex.core.util.Utils;
import convex.net.Connection;
import convex.net.message.Message;
import convex.net.message.MessageRemote;
import convex.peer.ChallengeRequest;
import convex.peer.Server;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(ConnectionManager.class.getName());
    static final long SERVER_CONNECTION_PAUSE = 1000L;
    static final long SERVER_POLL_DELAY = 2000L;
    static final long POLL_TIMEOUT_MILLIS = 2000L;
    static final long POLL_ACQUIRE_TIMEOUT_MILLIS = 10000L;
    protected final Server server;
    private final HashMap<AccountKey, Connection> connections = new HashMap();
    private final HashSet<InetSocketAddress> plannedConnections = new HashSet();
    private HashMap<AccountKey, ChallengeRequest> challengeList = new HashMap();
    private Thread connectionThread = null;
    private SecureRandom random = new SecureRandom();
    private long pollDelay;
    private long lastUpdate = Utils.getCurrentTimestamp();
    private Runnable connectionLoop = new Runnable(){

        @Override
        public void run() {
            Stores.setCurrent(ConnectionManager.this.server.getStore());
            try {
                ConnectionManager.this.lastUpdate = Utils.getCurrentTimestamp();
                while (ConnectionManager.this.server.isLive()) {
                    Thread.sleep(1000L);
                    ConnectionManager.this.makePlannedConnections();
                    ConnectionManager.this.maintainConnections();
                    ConnectionManager.this.pollBelief();
                    ConnectionManager.this.lastUpdate = Utils.getCurrentTimestamp();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable e) {
                log.error("Unexpected exception, Terminating Server connection loop");
                e.printStackTrace();
            }
            finally {
                ConnectionManager.this.connectionThread = null;
                ConnectionManager.this.closeAllConnections();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollBelief() {
        block8: {
            try {
                long lastConsensus = this.server.getPeer().getConsensusState().getTimeStamp().longValue();
                if (lastConsensus + this.pollDelay >= this.lastUpdate) {
                    return;
                }
                ArrayList<Connection> conns = new ArrayList<Connection>(this.connections.values());
                if (conns.size() == 0) {
                    return;
                }
                Connection c = conns.get(this.random.nextInt(conns.size()));
                if (c.isClosed()) {
                    return;
                }
                try (ConvexRemote convex = Convex.connect(c.getRemoteAddress());){
                    Result result = convex.requestStatusSync(2000L);
                    AVector status = (AVector)result.getValue();
                    Hash h = RT.ensureHash((ACell)status.get(0));
                    SignedData sb = (SignedData)convex.acquire(h).get(10000L, TimeUnit.MILLISECONDS);
                    this.server.queueEvent(sb);
                }
            }
            catch (Throwable t) {
                if (!this.server.isLive()) break block8;
                log.warn("Polling failed: {}", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makePlannedConnections() {
        HashSet<InetSocketAddress> hashSet = this.plannedConnections;
        synchronized (hashSet) {
            for (InetSocketAddress a : this.plannedConnections) {
                Connection c = this.connectToPeer(a);
                if (c == null) {
                    log.warn("Planned Connection failed to {}", (Object)a);
                    continue;
                }
                log.info("Planned Connection made to {}", (Object)a);
            }
            this.plannedConnections.clear();
        }
    }

    protected void maintainConnections() {
        AccountKey[] peers;
        State s = this.server.getPeer().getConsensusState();
        long millisSinceLastUpdate = Math.max(0L, Utils.getCurrentTimestamp() - this.lastUpdate);
        int targetPeerCount = this.getTargetPeerCount();
        int currentPeerCount = this.connections.size();
        double totalStake = s.computeStakes().get(null);
        for (AccountKey p : peers = this.connections.keySet().toArray(new AccountKey[currentPeerCount])) {
            double prop;
            double keepChance;
            Connection conn = this.connections.get(p);
            if (conn == null || conn.isClosed()) {
                this.closeConnection(p);
                --currentPeerCount;
                continue;
            }
            PeerStatus ps = s.getPeer(p);
            if (ps == null || ps.getTotalStake() <= 1000000000L) {
                this.closeConnection(p);
                --currentPeerCount;
                continue;
            }
            if (millisSinceLastUpdate > 0L && currentPeerCount >= targetPeerCount && (keepChance = Math.min(1.0, (prop = (double)ps.getTotalStake() / totalStake) * (double)targetPeerCount)) < 1.0) {
                double dropRate = (double)millisSinceLastUpdate / 20000.0;
                if (this.random.nextDouble() < dropRate * (1.0 - keepChance)) {
                    this.closeConnection(p);
                    --currentPeerCount;
                    continue;
                }
            }
            this.requestChallenge(p, conn, this.server.getPeer());
        }
        currentPeerCount = this.connections.size();
        peers = this.connections.keySet().toArray(new AccountKey[currentPeerCount]);
        if (peers.length < targetPeerCount) {
            Set potentialPeers = s.getPeers().keySet();
            InetSocketAddress target = null;
            double accStake = 0.0;
            for (ACell c : potentialPeers) {
                long peerStake;
                InetSocketAddress maybeAddress;
                AString hostName;
                PeerStatus ps;
                AccountKey peerKey = RT.ensureAccountKey(c);
                if (this.connections.containsKey(peerKey) || this.server.getPeerKey().equals(peerKey) || (ps = s.getPeers().get(peerKey)) == null || (hostName = ps.getHostname()) == null || (maybeAddress = Utils.toInetSocketAddress(hostName.toString())) == null || (peerStake = ps.getTotalStake()) <= 0L) continue;
                double t = this.random.nextDouble() * (accStake + (double)peerStake);
                if (t >= accStake) {
                    target = maybeAddress;
                }
                accStake += (double)peerStake;
            }
            if (target != null) {
                this.connectToPeer(target);
            }
        }
    }

    private int getTargetPeerCount() {
        Integer target;
        try {
            target = Utils.toInt(this.server.getConfig().get(Keywords.OUTGOING_CONNECTIONS));
        }
        catch (Exception ex) {
            target = null;
        }
        if (target == null) {
            target = Constants.DEFAULT_OUTGOING_CONNECTION_COUNT;
        }
        return target;
    }

    public ConnectionManager(Server server) {
        this.server = server;
        Object _pollDelay = server.getConfig().get(Keywords.POLL_DELAY);
        this.pollDelay = _pollDelay == null ? 2000L : (long)Utils.toInt(_pollDelay);
    }

    public synchronized void setConnection(AccountKey peerKey, Connection peerConnection) {
        if (this.connections.containsKey(peerKey)) {
            this.connections.get(peerKey).close();
            this.connections.replace(peerKey, peerConnection);
        } else {
            this.connections.put(peerKey, peerConnection);
        }
    }

    public synchronized void closeConnection(AccountKey peerKey) {
        if (this.connections.containsKey(peerKey)) {
            Connection conn = this.connections.get(peerKey);
            if (conn != null) {
                conn.close();
            }
            this.connections.remove(peerKey);
            this.server.raiseServerChange("connection");
        }
    }

    public synchronized void closeAllConnections() {
        for (Connection conn : this.connections.values()) {
            if (conn == null) continue;
            conn.close();
        }
        this.connections.clear();
    }

    public HashMap<AccountKey, Connection> getConnections() {
        return this.connections;
    }

    public boolean isConnected(AccountKey peerKey) {
        return this.connections.containsKey(peerKey);
    }

    public Connection getConnection(AccountKey peerKey) {
        if (!this.connections.containsKey(peerKey)) {
            return null;
        }
        return this.connections.get(peerKey);
    }

    public int getConnectionCount() {
        return this.connections.size();
    }

    public int getTrustedConnectionCount() {
        int result = 0;
        for (Connection connection : this.connections.values()) {
            if (!connection.isTrusted()) continue;
            ++result;
        }
        return result;
    }

    public void processChallenge(Message m, Peer thisPeer) {
        try {
            SignedData signedData = (SignedData)m.getPayload();
            if (signedData == null) {
                log.debug("challenge bad message data sent");
                return;
            }
            AVector challengeValues = (AVector)signedData.getValue();
            if (challengeValues == null || challengeValues.size() != 3) {
                log.debug("challenge data incorrect number of items should be 3 not ", (Object)RT.count(challengeValues));
                return;
            }
            Connection pc = ((MessageRemote)m).getConnection();
            if (pc == null) {
                log.warn("No remote peer connection from challenge");
                return;
            }
            Hash token = RT.ensureHash((ACell)challengeValues.get(0));
            if (token == null) {
                log.warn("no challenge token provided");
                return;
            }
            Hash networkId = RT.ensureHash((ACell)challengeValues.get(1));
            if (networkId == null) {
                log.warn("challenge data has no networkId");
                return;
            }
            if (!networkId.equals(thisPeer.getNetworkID())) {
                log.warn("challenge data has incorrect networkId");
                return;
            }
            AccountKey toPeer = RT.ensureAccountKey((ACell)challengeValues.get(2));
            if (toPeer == null) {
                log.warn("challenge data has no toPeer address");
                return;
            }
            if (!toPeer.equals(thisPeer.getPeerKey())) {
                log.warn("challenge data has incorrect addressed peer");
                return;
            }
            AccountKey fromPeer = signedData.getAccountKey();
            AVector responseValues = Vectors.of(token, thisPeer.getNetworkID(), fromPeer, signedData.getHash());
            SignedData<ACell> response = thisPeer.sign(responseValues);
            if (pc.sendResponse(response) == -1L) {
                log.warn("Failed sending response from challenge to ", (Object)pc.getRemoteAddress());
            }
        }
        catch (Throwable t) {
            log.error("Challenge Error: {}", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AccountKey processResponse(Message m, Peer thisPeer) {
        try {
            SignedData signedData = (SignedData)m.getPayload();
            log.debug("Processing response request from: {}", (Object)m.getOriginString());
            AVector responseValues = (AVector)signedData.getValue();
            if (responseValues.size() != 4) {
                log.warn("response data incorrect number of items should be 4 not {}", (Object)responseValues.size());
                return null;
            }
            Hash token = RT.ensureHash((ACell)responseValues.get(0));
            if (token == null) {
                log.warn("no response token provided");
                return null;
            }
            Hash networkId = RT.ensureHash((ACell)responseValues.get(1));
            if (networkId == null || !networkId.equals(thisPeer.getNetworkID())) {
                log.warn("response data has incorrect networkId");
                return null;
            }
            AccountKey toPeer = RT.ensureAccountKey((ACell)responseValues.get(2));
            if (toPeer == null || !toPeer.equals(thisPeer.getPeerKey())) {
                log.warn("response data has incorrect addressed peer");
                return null;
            }
            Hash challengeHash = RT.ensureHash((ACell)responseValues.get(3));
            AccountKey fromPeer = signedData.getAccountKey();
            if (!this.challengeList.containsKey(fromPeer)) {
                log.warn("response from an unkown challenge");
                return null;
            }
            HashMap<AccountKey, ChallengeRequest> hashMap = this.challengeList;
            synchronized (hashMap) {
                ChallengeRequest challengeRequest = this.challengeList.get(fromPeer);
                Hash challengeToken = challengeRequest.getToken();
                if (!challengeToken.equals(token)) {
                    log.warn("invalid response token sent");
                    return null;
                }
                AccountKey challengeFromPeer = challengeRequest.getPeerKey();
                if (!signedData.getAccountKey().equals(challengeFromPeer)) {
                    log.warn("response key does not match requested key, sent from a different peer");
                    return null;
                }
                Hash challengeSourceHash = challengeRequest.getSendHash();
                if (!challengeHash.equals(challengeSourceHash)) {
                    log.warn("response hash of the challenge does not match");
                    return null;
                }
                this.challengeList.remove(fromPeer);
                Connection connection = this.getConnection(fromPeer);
                if (connection != null) {
                    connection.setTrustedPeerKey(fromPeer);
                    this.server.raiseServerChange("trusted connection");
                }
                return fromPeer;
            }
        }
        catch (Throwable t) {
            log.error("Response Error: {}", t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestChallenge(AccountKey toPeerKey, Connection connection, Peer thisPeer) {
        HashMap<AccountKey, ChallengeRequest> hashMap = this.challengeList;
        synchronized (hashMap) {
            ChallengeRequest request;
            if (connection.isTrusted()) {
                return;
            }
            if (this.challengeList.containsKey(toPeerKey)) {
                if (!this.challengeList.get(toPeerKey).isTimedout()) {
                    return;
                }
                this.challengeList.remove(toPeerKey);
            }
            if ((request = ChallengeRequest.create(toPeerKey)).send(connection, thisPeer) >= 0L) {
                this.challengeList.put(toPeerKey, request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void broadcast(Message msg, boolean requireTrusted) {
        HashMap<AccountKey, Connection> hashMap = this.connections;
        synchronized (hashMap) {
            for (Connection pc : this.connections.values()) {
                try {
                    if ((!requireTrusted || !pc.isTrusted()) && requireTrusted) continue;
                    pc.sendMessage(msg);
                }
                catch (IOException e) {
                    log.error("Error in broadcast: ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection connectToPeer(InetSocketAddress hostAddress) {
        Connection newConn = null;
        try {
            ConvexRemote convex = Convex.connect(hostAddress);
            Result result = convex.requestStatusSync(6000L);
            AVector status = (AVector)result.getValue();
            if (status == null || status.count() != 5L) {
                throw new Error("Bad status message from remote Peer");
            }
            AccountKey peerKey = RT.ensureAccountKey((ACell)status.get(3));
            if (peerKey == null) {
                return null;
            }
            Connection existing = this.connections.get(peerKey);
            if (existing != null && !existing.isClosed()) {
                return existing;
            }
            ((Convex)convex).close();
            HashMap<AccountKey, Connection> hashMap = this.connections;
            synchronized (hashMap) {
                newConn = Connection.connect(hostAddress, this.server.peerReceiveAction, this.server.getStore(), null, 0x100000, 0x100000);
                this.connections.put(peerKey, newConn);
            }
            this.server.raiseServerChange("connection");
        }
        catch (IOException | TimeoutException convex) {
        }
        catch (UnresolvedAddressException e) {
            log.info("Unable to resolve host address: " + hostAddress);
        }
        return newConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToPeerAsync(InetSocketAddress hostAddress) {
        HashSet<InetSocketAddress> hashSet = this.plannedConnections;
        synchronized (hashSet) {
            this.plannedConnections.add(hostAddress);
        }
    }

    public void start() {
        this.lastUpdate = Utils.getCurrentTimestamp();
        this.connectionThread = new Thread(this.connectionLoop, "Connection Manager thread at " + this.server.getPort());
        this.connectionThread.setDaemon(true);
        this.connectionThread.start();
    }

    public void close() {
        if (this.connectionThread != null) {
            this.connectionThread.interrupt();
        }
    }
}

