/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.cli.Helpers;
import convex.cli.Local;
import convex.cli.Main;
import convex.cli.peer.PeerManager;
import convex.core.crypto.AKeyPair;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="start", aliases={"st"}, mixinStandardHelpOptions=true, description={"Starts a local convex test network."})
public class LocalStart
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(LocalStart.class);
    @CommandLine.ParentCommand
    private Local localParent;
    @CommandLine.Option(names={"--count"}, defaultValue="4", description={"Number of local peers to start. Default: ${DEFAULT-VALUE}"})
    private int count;
    @CommandLine.Option(names={"-i", "--index-key"}, defaultValue="0", description={"One or more keystore index of the public/private key to use to run a peer."})
    private String[] keystoreIndex;
    @CommandLine.Option(names={"--public-key"}, defaultValue="", description={"One or more hex string of the public key in the Keystore to use to run a peer.%nYou only need to enter in the first distinct hex values of the public key.%nFor example: 0xf0234 or f0234"})
    private String[] keystorePublicKey;
    @CommandLine.Option(names={"--ports"}, description={"Range or list of ports to assign each peer in the cluster. This can be a multiple of --ports %nor a single --ports=8081,8082,8083 or --ports=8080-8090"})
    private String[] ports;

    @Override
    public void run() {
        AKeyPair keyPair;
        int index;
        List<String> values;
        Main mainParent = this.localParent.mainParent;
        PeerManager peerManager = PeerManager.create(mainParent.getSessionFilename());
        List<Object> keyPairList = new ArrayList();
        if (this.keystorePublicKey.length > 0) {
            values = Helpers.splitArrayParameter(this.keystorePublicKey);
            for (index = 0; index < values.size(); ++index) {
                String publicKeyText = values.get(index);
                try {
                    keyPair = mainParent.loadKeyFromStore(publicKeyText, 0);
                    if (keyPair == null) continue;
                    keyPairList.add(keyPair);
                    continue;
                }
                catch (Error e) {
                    mainParent.showError(e);
                    return;
                }
            }
        }
        if (this.keystoreIndex.length > 0) {
            values = Helpers.splitArrayParameter(this.keystoreIndex);
            for (index = 0; index < values.size(); ++index) {
                int indexKey = Integer.parseInt(values.get(index));
                if (indexKey <= 0) continue;
                try {
                    keyPair = mainParent.loadKeyFromStore("", indexKey);
                    if (keyPair == null) continue;
                    keyPairList.add(keyPair);
                    continue;
                }
                catch (Error e) {
                    mainParent.showError(e);
                    return;
                }
            }
        }
        if (keyPairList.size() == 0) {
            keyPairList = mainParent.generateKeyPairs(this.count);
        }
        if (this.count > keyPairList.size()) {
            log.error("Not enougth public keys provided. You have requested {} peers to start, but only provided {} public keys", (Object)this.count, (Object)keyPairList.size());
        }
        int[] peerPorts = null;
        if (this.ports != null) {
            try {
                peerPorts = mainParent.getPortList(this.ports, this.count);
            }
            catch (NumberFormatException e) {
                log.warn("cannot convert port number " + e);
                return;
            }
            if (peerPorts.length < this.count) {
                log.warn("you need only provided {} ports you need to provide at least {} ports", (Object)peerPorts.length, (Object)this.count);
                return;
            }
        }
        log.info("Starting local network with " + this.count + " peer(s)");
        peerManager.launchLocalPeers(keyPairList, peerPorts);
        log.info("Local Peers launched");
        peerManager.showPeerEvents();
    }
}

