/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.mixins;

import convex.cli.CLIError;
import convex.cli.mixins.AMixin;
import convex.core.util.FileUtils;
import convex.etch.EtchStore;
import java.io.File;
import java.io.IOException;
import picocli.CommandLine;

public class EtchMixin
extends AMixin {
    @CommandLine.Option(names={"-e", "--etch"}, scope=CommandLine.ScopeType.INHERIT, defaultValue="${env:CONVEX_ETCH_FILE:-~/.convex/etch.db}", description={"Etch database. Defaults to CONVEX_ETCH_FILE or ~/.convex/etch.db"})
    String etchStoreFilename;
    EtchStore etch = null;

    public synchronized EtchStore getEtchStore(String fileName) {
        if (this.etch != null) {
            return this.etch;
        }
        if (fileName == null) {
            throw new CLIError("No Etch store file specified. Maybe include --etch option or set environment variable CONVEX_ETCH_FILE ?");
        }
        File etchFile = FileUtils.getFile((String)fileName);
        try {
            this.etch = EtchStore.create((File)etchFile);
            return this.etch;
        }
        catch (IOException e) {
            throw new CLIError("Unable to load Etch store at: " + String.valueOf(etchFile) + " cause: " + e.getMessage());
        }
    }

    public EtchStore getEtchStore() {
        return this.getEtchStore(this.etchStoreFilename);
    }
}

