/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.key;

import convex.cli.CLIError;
import convex.cli.key.AKeyCommand;
import convex.cli.key.Key;
import convex.cli.mixins.KeyMixin;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.ASignature;
import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.Blobs;
import convex.core.util.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import picocli.CommandLine;

@CommandLine.Command(name="sign", mixinStandardHelpOptions=false, description={"Sign some data using a key from the store."})
public class KeySign
extends AKeyCommand {
    @CommandLine.ParentCommand
    protected Key keyParent;
    @CommandLine.Mixin
    protected KeyMixin keyMixin;
    @CommandLine.Option(names={"-o", "--output-file"}, description={"Output file for the signature. Use '-' for STDOUT (default)."})
    private String outputFilename;
    @CommandLine.Option(names={"-i", "--input-file"}, description={"Output file for the signature. Use '-' for STDIN."})
    private String inputFilename;
    @CommandLine.Option(names={"--hex"}, description={"Hex data to sign. Used instead of --input-file if specified"})
    private String dataString;

    @Override
    public void execute() {
        String publicKey;
        AKeyPair keyPair;
        String keystorePublicKey = this.keyMixin.getPublicKey();
        if (keystorePublicKey == null || keystorePublicKey.isEmpty()) {
            if (!this.isInteractive()) {
                this.cli().inform("You must provide a --key parameter for signing");
                this.showUsage();
                return;
            }
            keystorePublicKey = this.cli().prompt("Specify key to use for signature: ");
        }
        if ((keyPair = this.storeMixin.loadKeyFromStore(publicKey = keystorePublicKey, this.keyMixin.getKeyPassword())) == null) {
            throw new CLIError(67, "Key pair not found for requested signing key: " + keystorePublicKey);
        }
        if (this.dataString == null) {
            if (this.inputFilename != null && this.inputFilename.length() > 0) {
                try {
                    this.dataString = FileUtils.loadFileAsString((String)this.inputFilename);
                }
                catch (IOException ex) {
                    throw new CLIError(74, ex.getMessage());
                }
            } else if (this.isInteractive()) {
                this.dataString = this.prompt("Enter hex data to sign: ");
            } else {
                throw new CLIError("No input file specified");
            }
        }
        this.dataString = this.dataString.replaceAll("\\s+", "");
        ABlob data = Blobs.parse((String)this.dataString);
        if (data == null) {
            throw new CLIError(65, "Can't parse data, expecting a hex string.");
        }
        ASignature sig = keyPair.sign((AArrayBlob)data.toFlatBlob());
        String output = sig.toHexString();
        if (this.outputFilename == null || "-".equals(this.outputFilename.trim())) {
            this.println(output);
        } else {
            try {
                FileUtils.writeFileAsString((Path)Paths.get(this.outputFilename, new String[0]), (String)output);
            }
            catch (IOException e) {
                throw new CLIError("Failed to write output file: " + e.getMessage());
            }
        }
    }
}

