/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.utils;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.plaf.FontUIResource;
import mdlaf.utils.Utils;

public class MaterialFontFactory {
    private static final Map<TextAttribute, Object> fontSettings = new HashMap<TextAttribute, Object>();
    public static final MaterialTypeFont REGULAR = MaterialTypeFont.REGULAR;
    public static final MaterialTypeFont BOLD = MaterialTypeFont.BOLD;
    public static final MaterialTypeFont ITALIC = MaterialTypeFont.ITALIC;
    public static final MaterialTypeFont MEDIUM = MaterialTypeFont.MEDIUM;
    private static MaterialFontFactory SINGLETON;
    protected Properties properties = new Properties();
    protected Map<String, FontUIResource> cacheFont = new HashMap<String, FontUIResource>();
    protected float defaultSize = 14.0f;
    protected boolean withPersonalSettings = true;

    public static MaterialFontFactory getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new MaterialFontFactory();
        }
        return SINGLETON;
    }

    @Deprecated
    public static Font fontUtilsDisplayable(String textDisplayable, Font withFont) {
        if (textDisplayable == null || withFont == null) {
            throw new IllegalArgumentException("Argument at the fontUtilsDisplayable function are/is null");
        }
        if (withFont.canDisplayUpTo(textDisplayable) < 0) {
            return withFont;
        }
        return new FontUIResource("SansSerif", withFont.getStyle(), withFont.getSize());
    }

    private MaterialFontFactory() {
        try {
            this.loadOsProprieties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FontUIResource getFontWithPath(String path) {
        return this.getFontWithPath(path, this.withPersonalSettings);
    }

    public FontUIResource getFontWithStream(InputStream stream) {
        return this.getFontWithStream(stream, this.withPersonalSettings);
    }

    public FontUIResource getFont(MaterialTypeFont typeFont) {
        return this.getFont(typeFont, this.withPersonalSettings);
    }

    public FontUIResource getFont(MaterialTypeFont typeFont, boolean withPersonalSettings) {
        if (typeFont == null) {
            throw new IllegalArgumentException("\n- Parameter type font null.\n");
        }
        String typeFontString = typeFont.toString();
        if (this.cacheFont.containsKey(typeFontString)) {
            return this.cacheFont.get(typeFontString);
        }
        String proprieties = this.properties.getProperty(typeFontString);
        FontUIResource font = this.getFontWithPath(proprieties);
        this.cacheFont.put(typeFontString, font);
        return font;
    }

    public FontUIResource getFontWithPath(String path, boolean withPersonalSettings) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("\n- The path to load personal fort is null or empty");
        }
        InputStream stream = this.getClass().getResourceAsStream(path);
        return this.loadFont(stream, withPersonalSettings);
    }

    public FontUIResource getFontWithStream(InputStream stream, boolean withPersonalSettings) {
        if (stream == null) {
            throw new IllegalArgumentException("\n- The stream to load personal fort is null");
        }
        return this.loadFont(stream, withPersonalSettings);
    }

    private FontUIResource loadFont(InputStream inputStream, boolean withPersonalSettings) {
        float size;
        float f = size = withPersonalSettings ? this.doOptimizingDimensionFont(this.defaultSize) : this.defaultSize;
        if (withPersonalSettings && fontSettings.isEmpty()) {
            fontSettings.put(TextAttribute.SIZE, Float.valueOf(size));
            fontSettings.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
        }
        try {
            if (withPersonalSettings) {
                Font font = Font.createFont(0, inputStream).deriveFont(fontSettings);
                return new FontUIResource(font);
            }
            Font font = Font.createFont(0, inputStream).deriveFont(size);
            return new FontUIResource(font);
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Font " + inputStream.toString() + " wasn't loaded");
        }
    }

    public float doOptimizingDimensionFont(float dimension) {
        if (this.defaultSize <= 0.0f) {
            throw new IllegalArgumentException("\n- The dimension should be positive (>= 0)");
        }
        if (Utils.isJavaVersionUnderJava9()) {
            float dimensionOptimized = 11.0f * (float)Math.min(Toolkit.getDefaultToolkit().getScreenResolution(), 96) / 72.0f;
            if (dimensionOptimized <= dimension - 3.0f) {
                return 14.666667f;
            }
            return dimensionOptimized;
        }
        return dimension;
    }

    private void loadOsProprieties() throws IOException {
        this.properties.load(this.getClass().getResourceAsStream("/config/fonts.properties"));
    }

    protected static enum MaterialTypeFont {
        REGULAR("REGULAR"),
        BOLD("BOLD"),
        ITALIC("ITALIC"),
        MEDIUM("MEDIUM");

        private String type;

        private MaterialTypeFont(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

