/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.api.Convex;
import convex.core.Belief;
import convex.core.Block;
import convex.core.BlockResult;
import convex.core.ErrorCodes;
import convex.core.Peer;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.PeerStatus;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.BadSignatureException;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.MissingDataException;
import convex.core.init.Init;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import convex.core.util.Shutdown;
import convex.core.util.Utils;
import convex.net.Connection;
import convex.net.Message;
import convex.net.MessageType;
import convex.net.NIOServer;
import convex.peer.ConnectionManager;
import convex.peer.IServerEvent;
import convex.peer.ServerEvent;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements Closeable {
    public static final int DEFAULT_PORT = 18888;
    private static final int RECEIVE_QUEUE_SIZE = 10000;
    private static final int EVENT_QUEUE_SIZE = 1000;
    private static final long SERVER_UPDATE_PAUSE = 5L;
    static final Logger log = LoggerFactory.getLogger(Server.class.getName());
    private BlockingQueue<Message> receiveQueue = new ArrayBlockingQueue<Message>(10000);
    private BlockingQueue<SignedData<?>> eventQueue = new ArrayBlockingQueue(1000);
    Consumer<Message> peerReceiveAction = new Consumer<Message>(){

        @Override
        public void accept(Message msg) {
            try {
                Server.this.receiveQueue.put(msg);
            }
            catch (InterruptedException e) {
                log.warn("Interrupt on peer receive queue!");
            }
        }
    };
    protected ConnectionManager manager;
    private final AStore store;
    private final HashMap<Keyword, Object> config;
    private volatile boolean isRunning = false;
    private NIOServer nio;
    private Thread receiverThread = null;
    private Thread updateThread = null;
    private Peer peer;
    private Address controller;
    private ArrayList<SignedData<ATransaction>> newTransactions = new ArrayList();
    private HashMap<Hash, Message> partialMessages = new HashMap();
    private HashMap<AccountKey, SignedData<Belief>> newBeliefs = new HashMap();
    String hostname;
    private IServerEvent eventHook = null;
    private HashMap<Hash, Message> interests = new HashMap();
    private long lastBroadcastBelief = 0L;
    private long broadcastCount = 0L;
    private long lastBlockPublishedTime = 0L;
    private long lastOwnTransactionTimestamp = 0L;
    private static final long OWN_TRANSACTIONS_DELAY = 300L;
    private Runnable receiverLoop = new Runnable(){

        @Override
        public void run() {
            Stores.setCurrent(Server.this.getStore());
            try {
                log.debug("Reciever thread started for peer at {}", (Object)Server.this.getHostAddress());
                while (Server.this.isRunning) {
                    Message m = Server.this.receiveQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (m == null) continue;
                    Server.this.processMessage(m);
                }
                log.debug("Reciever thread terminated normally for peer {}", (Object)this);
            }
            catch (InterruptedException e) {
                log.debug("Receiver thread interrupted ");
            }
            catch (Throwable e) {
                log.warn("Receiver thread terminated abnormally! ");
                log.error("Server FAILED: " + e.getMessage());
                e.printStackTrace();
            }
        }
    };
    private final Runnable updateLoop = new Runnable(){

        @Override
        public void run() {
            Stores.setCurrent(Server.this.getStore());
            try {
                while (Server.this.isRunning) {
                    long timestamp = Utils.getCurrentTimestamp();
                    if (Server.this.maybeUpdateBelief()) {
                        Server.this.raiseServerChange("consensus");
                    }
                    if (Server.this.lastBroadcastBelief + 200L < timestamp && Server.this.peer.getConsensusPoint() < Server.this.peer.getPeerOrder().getBlockCount()) {
                        Server.this.broadcastBelief(Server.this.peer.getBelief());
                    }
                    Server.this.awaitEvents();
                }
            }
            catch (InterruptedException e) {
                log.debug("Terminating Server update due to interrupt");
            }
            catch (Throwable e) {
                log.error("Unexpected exception in server update loop: {}", e);
                log.error("Terminating Server update");
                e.printStackTrace();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Server(HashMap<Keyword, Object> config) throws TimeoutException, IOException {
        Object maybeHook;
        AStore configStore = (AStore)config.get(Keywords.STORE);
        AStore aStore = this.store = configStore == null ? Stores.current() : configStore;
        if (config.containsKey(Keywords.EVENT_HOOK) && (maybeHook = config.get(Keywords.EVENT_HOOK)) instanceof IServerEvent) {
            this.eventHook = (IServerEvent)maybeHook;
        }
        AStore savedStore = Stores.current();
        try {
            Stores.setCurrent(this.store);
            this.config = config;
            this.manager = new ConnectionManager(this);
            this.peer = this.establishPeer();
            this.establishController();
            this.nio = NIOServer.create(this, this.receiveQueue);
        }
        finally {
            Stores.setCurrent(savedStore);
        }
    }

    private void establishController() {
        Address controlAddress = RT.toAddress(this.getConfig().get(Keywords.CONTROLLER));
        if (controlAddress == null && (controlAddress = this.peer.getController()) == null) {
            throw new IllegalStateException("Peer Controller account does not exist for Peer Key: " + this.peer.getPeerKey());
        }
        AccountStatus as = this.peer.getConsensusState().getAccount(controlAddress);
        if (as == null) {
            throw new IllegalStateException("Peer Controller Account does not exist: " + controlAddress);
        }
        if (!as.getAccountKey().equals(this.getKeyPair().getAccountKey())) {
            throw new IllegalStateException("Server keypair does not match keypair for control account: " + controlAddress);
        }
        this.setPeerController(controlAddress);
    }

    private Peer establishPeer() throws TimeoutException, IOException {
        log.info("Establishing Peer with store: {}", (Object)Stores.current());
        try {
            State genesisState;
            Object source;
            AKeyPair keyPair = (AKeyPair)this.getConfig().get(Keywords.KEYPAIR);
            if (keyPair == null) {
                log.warn("No keypair provided for Server, deafulting to generated keypair for testing purposes");
                keyPair = AKeyPair.generate();
                log.warn("Generated keypair with public key: " + keyPair.getAccountKey());
            }
            if (Utils.bool(source = this.getConfig().get(Keywords.SOURCE))) {
                InetSocketAddress sourceAddr = Utils.toInetSocketAddress(source);
                Convex convex = Convex.connect(sourceAddr);
                log.info("Attempting Peer Sync with: " + sourceAddr);
                long timeout = this.establishTimeout();
                Result result = convex.requestStatusSync(timeout);
                AVector status = (AVector)result.getValue();
                if (status == null || status.count() != 5L) {
                    throw new Error("Bad status message from remote Peer");
                }
                Hash beliefHash = RT.ensureHash((ACell)status.get(0));
                Hash networkID = RT.ensureHash((ACell)status.get(2));
                log.info("Attempting to sync genesis state with network: " + networkID);
                State genF = (State)convex.acquire(networkID).get(timeout, TimeUnit.MILLISECONDS);
                log.info("Retreived Genesis State: " + networkID);
                log.info("Attempting to obtain peer Belief: " + beliefHash);
                ACell belF = null;
                long timeElapsed = 0L;
                while (belF == null) {
                    try {
                        belF = (SignedData)convex.acquire(beliefHash).get(timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException te) {
                        log.info("Still waiting for Belief sync after " + (timeElapsed += timeout) / 1000L + "s");
                    }
                }
                log.info("Retreived Peer Signed Belief: " + beliefHash + " with memory size: " + belF.getMemorySize());
                Peer peer = Peer.create(keyPair, genF, (Belief)((SignedData)belF).getValue());
                return peer;
            }
            if (Utils.bool(this.getConfig().get(Keywords.RESTORE))) {
                try {
                    Peer peer = Peer.restorePeer(this.store, keyPair);
                    if (peer != null) {
                        log.info("Restored Peer with root data hash: {}", (Object)this.store.getRootHash());
                        return peer;
                    }
                }
                catch (Throwable e) {
                    log.error("Can't restore Peer from store: {}", e);
                }
            }
            if ((genesisState = (State)this.config.get(Keywords.STATE)) != null) {
                log.info("Defaulting to standard Peer startup with genesis state: " + genesisState.getHash());
            } else {
                AccountKey peerKey = keyPair.getAccountKey();
                genesisState = Init.createState(List.of(peerKey));
                log.info("Created new genesis state: " + genesisState.getHash() + " with initial peer: " + peerKey);
            }
            return Peer.createGenesisPeer(keyPair, genesisState);
        }
        catch (InterruptedException | ExecutionException e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
    }

    private long establishTimeout() {
        Object maybeTimeout = this.getConfig().get(Keywords.TIMEOUT);
        if (maybeTimeout == null) {
            return 60000L;
        }
        Utils.toInt(maybeTimeout);
        return 0L;
    }

    public static Server create(HashMap<Keyword, Object> config) throws TimeoutException, IOException {
        return new Server(new HashMap<Keyword, Object>(config));
    }

    public Belief getBelief() {
        return this.peer.getBelief();
    }

    public Peer getPeer() {
        return this.peer;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void launch() {
        AStore savedStore = Stores.current();
        try {
            Stores.setCurrent(this.store);
            HashMap<Keyword, Object> config = this.getConfig();
            Object p = config.get(Keywords.PORT);
            Integer port = p == null ? null : Integer.valueOf(Utils.toInt(p));
            this.nio.launch((String)config.get(Keywords.BIND_ADDRESS), port);
            port = this.nio.getPort();
            if (this.getConfig().containsKey(Keywords.URL)) {
                this.hostname = (String)config.get(Keywords.URL);
                log.debug("Setting desired peer URL to: " + this.hostname);
            } else {
                this.hostname = null;
            }
            this.isRunning = true;
            this.manager.start();
            this.receiverThread = new Thread(this.receiverLoop, "Receive Loop on port: " + port);
            this.receiverThread.setDaemon(true);
            this.receiverThread.start();
            this.updateThread = new Thread(this.updateLoop, "Update Loop on port: " + port);
            this.updateThread.setDaemon(true);
            this.updateThread.start();
            Shutdown.addHook(80, new Runnable(){

                @Override
                public void run() {
                    Server.this.close();
                }
            });
            if (this.getConfig().containsKey(Keywords.SOURCE)) {
                Object s = this.getConfig().get(Keywords.SOURCE);
                InetSocketAddress sa = Utils.toInetSocketAddress(s);
                if (sa != null) {
                    if (this.manager.connectToPeer(sa) != null) {
                        log.debug("Automatically connected to :source peer at: {}", (Object)sa);
                    } else {
                        log.warn("Failed to connect to :source peer at: {}", (Object)sa);
                    }
                } else {
                    log.warn("Failed to parse :source peer address {}", s);
                }
            }
            log.info("Peer Server started with Peer Address: {}", (Object)this.getPeerKey());
        }
        catch (Throwable e) {
            this.close();
            throw new Error("Failed to launch Server", e);
        }
        finally {
            Stores.setCurrent(savedStore);
        }
    }

    private void processMessage(Message m) {
        MessageType type = m.getType();
        log.trace("Processing message {}", (Object)type);
        try {
            switch (type) {
                case BELIEF: {
                    this.processBelief(m);
                    break;
                }
                case CHALLENGE: {
                    this.processChallenge(m);
                    break;
                }
                case RESPONSE: {
                    this.processResponse(m);
                    break;
                }
                case COMMAND: {
                    break;
                }
                case DATA: {
                    this.processData(m);
                    break;
                }
                case MISSING_DATA: {
                    this.processMissingData(m);
                    break;
                }
                case QUERY: {
                    this.processQuery(m);
                    break;
                }
                case RESULT: {
                    break;
                }
                case TRANSACT: {
                    this.processTransact(m);
                    break;
                }
                case GOODBYE: {
                    this.processClose(m);
                    break;
                }
                case STATUS: {
                    this.processStatus(m);
                }
            }
        }
        catch (MissingDataException e) {
            Hash missingHash = e.getMissingHash();
            log.trace("Missing data: {} in message of type {}", (Object)missingHash, (Object)type);
            try {
                this.registerPartialMessage(missingHash, m);
                m.getConnection().sendMissingData(missingHash);
                log.trace("Requested missing data {} for partial message", (Object)missingHash);
            }
            catch (IOException ex) {
                log.warn("Exception while requesting missing data: {}" + ex);
            }
        }
        catch (BadFormatException | ClassCastException | NullPointerException e) {
            log.warn("Error processing client message: {}", e);
        }
    }

    private void processMissingData(Message m) throws BadFormatException {
        Hash h = RT.ensureHash(m.getPayload());
        if (h == null) {
            throw new BadFormatException("Hash required for missing data message");
        }
        Ref r = this.store.refForHash(h);
        if (r != null) {
            try {
                Object data = r.getValue();
                boolean sent = m.getConnection().sendData((ACell)data);
                if (!sent) {
                    log.debug("Can't send missing data for hash {} due to full buffer", (Object)h);
                }
            }
            catch (IOException e) {
                log.warn("Unable to deliver missing data for {} due to exception: {}", (Object)h, (Object)e);
            }
        } else {
            log.debug("Unable to provide missing data for {} from store: {}", (Object)h, (Object)Stores.current());
        }
    }

    private void processTransact(Message m) {
        AVector v = (AVector)m.getPayload();
        SignedData sd = (SignedData)v.get(1);
        ACell.createPersisted(sd);
        if (!sd.checkSignature()) {
            try {
                m.getConnection().sendResult(m.getID(), Strings.create("Bad Signature!"), ErrorCodes.SIGNATURE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.info("Bad signature from Client! {}", (Object)sd);
            return;
        }
        this.registerInterest(sd.getHash(), m);
        try {
            this.eventQueue.put(sd);
        }
        catch (InterruptedException e) {
            log.warn("Unexpected interruption adding transaction to event queue!");
        }
    }

    private void processClose(Message m) {
        SignedData signedPeerKey = (SignedData)m.getPayload();
        AccountKey remotePeerKey = RT.ensureAccountKey(signedPeerKey.getValue());
        this.manager.closeConnection(remotePeerKey);
        this.raiseServerChange("connection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeProcessPartial(Hash hash) {
        HashMap<Hash, Message> hashMap = this.partialMessages;
        synchronized (hashMap) {
            Message m = this.partialMessages.get(hash);
            if (m != null) {
                log.trace("Attempting to re-queue partial message due to received hash: ", (Object)hash);
                if (this.receiveQueue.offer(m)) {
                    this.partialMessages.remove(hash);
                    return true;
                }
                log.warn("Queue full for message with received hash: {}", (Object)hash);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPartialMessage(Hash missingHash, Message m) {
        HashMap<Hash, Message> hashMap = this.partialMessages;
        synchronized (hashMap) {
            log.trace("Registering partial message with missing hash: ", (Object)missingHash);
            this.partialMessages.put(missingHash, m);
        }
    }

    private void registerInterest(Hash signedTransactionHash, Message m) {
        this.interests.put(signedTransactionHash, m);
    }

    protected boolean maybeUpdateBelief() throws InterruptedException {
        long oldConsensusPoint = this.peer.getConsensusPoint();
        this.maybePostOwnTransactions();
        boolean published = this.maybePublishBlock();
        if (!published && this.newBeliefs.isEmpty()) {
            return false;
        }
        this.peer = this.peer.updateTimestamp(Utils.getCurrentTimestamp());
        boolean updated = this.maybeMergeBeliefs();
        if (!updated && !published) {
            return false;
        }
        Belief belief = this.peer.getBelief();
        this.broadcastBelief(belief);
        long newConsensusPoint = this.peer.getConsensusPoint();
        if (newConsensusPoint > oldConsensusPoint) {
            log.debug("Consensus point update from {} to {}", (Object)oldConsensusPoint, (Object)newConsensusPoint);
            for (long i = oldConsensusPoint; i < newConsensusPoint; ++i) {
                Block block = this.peer.getPeerOrder().getBlock(i);
                BlockResult br = this.peer.getBlockResult(i);
                this.reportTransactions(block, br);
            }
        }
        return true;
    }

    private void broadcastBelief(Belief belief) {
        Consumer<Ref<ACell>> noveltyHandler = r -> {
            Object o = r.getValue();
            if (o == belief) {
                return;
            }
            Message msg = Message.createData(o);
            this.manager.broadcast(msg, false);
        };
        this.peer = this.peer.persistState(noveltyHandler);
        SignedData<Belief> sb = this.peer.getSignedBelief();
        Message msg = Message.createBelief(sb);
        this.manager.broadcast(msg, false);
        this.lastBroadcastBelief = Utils.getCurrentTimestamp();
        ++this.broadcastCount;
    }

    public long getBroadcastCount() {
        return this.broadcastCount;
    }

    protected boolean maybePublishBlock() {
        long timestamp = Utils.getCurrentTimestamp();
        if (this.lastBlockPublishedTime + 100L > timestamp) {
            return false;
        }
        Block block = null;
        int n = this.newTransactions.size();
        if (n == 0) {
            return false;
        }
        block = Block.create(timestamp, this.newTransactions, this.peer.getPeerKey());
        this.newTransactions.clear();
        ACell.createPersisted(block);
        Peer newPeer = this.peer.proposeBlock(block);
        log.info("New block proposed: {} transaction(s), hash={}", (Object)block.getTransactions().count(), (Object)block.getHash());
        this.peer = newPeer;
        this.lastBlockPublishedTime = timestamp;
        return true;
    }

    public Address getPeerController() {
        return this.controller;
    }

    public void setPeerController(Address a) {
        this.controller = a;
    }

    public void queueEvent(SignedData<?> event) throws InterruptedException {
        this.eventQueue.put(event);
    }

    private void maybePostOwnTransactions() {
        String currentHostname;
        if (!Utils.bool(this.config.get(Keywords.AUTO_MANAGE))) {
            return;
        }
        State s = this.getPeer().getConsensusState();
        long ts = Utils.getCurrentTimestamp();
        if (ts < this.lastOwnTransactionTimestamp + 300L) {
            return;
        }
        this.lastOwnTransactionTimestamp = ts;
        String desiredHostname = this.getHostname();
        AccountKey peerKey = this.getPeerKey();
        PeerStatus ps = s.getPeer(peerKey);
        AString chn = ps.getHostname();
        String string = currentHostname = chn == null ? null : chn.toString();
        if (!Utils.equals(desiredHostname, currentHostname)) {
            AccountStatus as;
            log.info("Trying to update own hostname from: {} to {}", (Object)currentHostname, (Object)desiredHostname);
            Address address = ps.getController();
            if (address != null && (as = s.getAccount(address)) != null && Utils.equals(this.getPeerKey(), as.getAccountKey())) {
                String code = desiredHostname == null ? String.format("(set-peer-data %s {:url nil})", peerKey) : String.format("(set-peer-data %s {:url \"%s\"})", peerKey, desiredHostname);
                Object message = Reader.read(code);
                Invoke transaction = Invoke.create(address, as.getSequence() + 1L, message);
                this.newTransactions.add(this.getKeyPair().signData(transaction));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean maybeMergeBeliefs() {
        try {
            Belief[] beliefs;
            HashMap<AccountKey, SignedData<Belief>> hashMap = this.newBeliefs;
            synchronized (hashMap) {
                int n = this.newBeliefs.size();
                beliefs = new Belief[n];
                int i = 0;
                for (AccountKey addr : this.newBeliefs.keySet()) {
                    beliefs[i++] = this.newBeliefs.get(addr).getValue();
                }
                this.newBeliefs.clear();
            }
            Peer newPeer = this.peer.mergeBeliefs(beliefs);
            if (newPeer.getBelief().getOrders().equals(this.peer.getBelief().getOrders())) {
                return false;
            }
            log.debug("New merged Belief update: {}", (Object)newPeer.getBelief().getHash());
            this.peer = newPeer;
            return true;
        }
        catch (MissingDataException e) {
            throw new Error("Missing data in belief update: " + e.getMissingHash().toHexString(), e);
        }
        catch (BadSignatureException e) {
            throw new Error("Bad Signature in belief update!", e);
        }
        catch (InvalidDataException e) {
            throw new Error("Invalid data in belief update!", e);
        }
    }

    private void processStatus(Message m) {
        try {
            Connection pc = m.getConnection();
            log.debug("Processing status request from: {}", (Object)pc.getRemoteAddress());
            Peer peer = this.getPeer();
            Hash beliefHash = peer.getSignedBelief().getHash();
            Hash stateHash = peer.getStates().getHash();
            Hash initialStateHash = ((State)peer.getStates().get(0)).getHash();
            AccountKey peerKey = this.getPeerKey();
            Hash consensusHash = peer.getConsensusState().getHash();
            AVector reply = Vectors.of(beliefHash, stateHash, initialStateHash, peerKey, consensusHash);
            pc.sendResult(m.getID(), reply);
        }
        catch (Throwable t) {
            log.warn("Status Request Error: {}", t);
        }
    }

    private void processChallenge(Message m) {
        this.manager.processChallenge(m, this.peer);
    }

    private void processResponse(Message m) {
        this.manager.processResponse(m, this.peer);
    }

    private void processQuery(Message m) {
        try {
            AVector v = (AVector)m.getPayload();
            CVMLong id = (CVMLong)v.get(0);
            Object form = v.get(1);
            Address address = (Address)v.get(2);
            Connection pc = m.getConnection();
            log.debug("Processing query: {} with address: {}", form, (Object)address);
            Context resultContext = this.peer.executeQuery((ACell)form, address);
            boolean resultReturned = resultContext.isExceptional() ? pc.sendResult(Result.fromContext(id, resultContext)) : pc.sendResult(id, (ACell)resultContext.getResult());
            if (!resultReturned) {
                log.warn("Failed to send query result back to client with ID: {}", (Object)id);
            }
        }
        catch (Throwable t) {
            log.warn("Query Error: {}", t);
        }
    }

    private void processData(Message m) {
        Object payload = m.getPayload();
        Ref<Object> r = Ref.get(payload);
        r = r.persistShallow();
        Hash payloadHash = r.getHash();
        if (log.isTraceEnabled()) {
            log.trace("Processing DATA of type: " + Utils.getClassName(payload) + " with hash: " + payloadHash.toHexString() + " and encoding: " + Format.encodedBlob(payload).toHexString());
        }
        this.maybeProcessPartial(r.getHash());
    }

    private void processBelief(Message m) {
        Connection pc = m.getConnection();
        if (pc.isClosed()) {
            return;
        }
        Object o = m.getPayload();
        Ref<Object> ref = Ref.get(o);
        try {
            ref = ref.persist();
            SignedData receivedBelief = (SignedData)o;
            receivedBelief.validateSignature();
            this.eventQueue.put(receivedBelief);
        }
        catch (ClassCastException e) {
            log.warn("Exception due to bad message from peer? {}", e);
        }
        catch (BadSignatureException e) {
            log.warn("Bad signed belief from peer: " + Utils.print(o));
        }
        catch (InterruptedException e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
    }

    private void awaitEvents() throws InterruptedException {
        SignedData<?> firstEvent = this.eventQueue.poll(5L, TimeUnit.MILLISECONDS);
        if (firstEvent == null) {
            return;
        }
        ArrayList allEvents = new ArrayList();
        allEvents.add(firstEvent);
        this.eventQueue.drainTo(allEvents);
        for (SignedData signedData : allEvents) {
            Object event = signedData.getValue();
            if (event instanceof ATransaction) {
                SignedData receivedTrans = signedData;
                this.newTransactions.add(receivedTrans);
                continue;
            }
            if (event instanceof Belief) {
                SignedData receivedBelief = signedData;
                AccountKey addr = receivedBelief.getAccountKey();
                SignedData<Belief> current = this.newBeliefs.get(addr);
                if (current != null && current.getValue().getTimestamp() > ((Belief)receivedBelief.getValue()).getTimestamp()) continue;
                this.newBeliefs.put(addr, receivedBelief);
                log.debug("Valid belief received by peer at {}: {}", (Object)this.getHostAddress(), (Object)((Belief)receivedBelief.getValue()).getHash());
                continue;
            }
            throw new Error("Unexpected type in event queue!" + Utils.getClassName(event));
        }
    }

    private void reportTransactions(Block block, BlockResult br) {
        int nTrans = block.length();
        for (long j = 0L; j < (long)nTrans; ++j) {
            try {
                SignedData<ATransaction> t = block.getTransactions().get(j);
                Hash h = t.getHash();
                Message m = this.interests.get(h);
                if (m == null) continue;
                log.trace("Returning transaction result to ", (Object)m.getConnection().getRemoteAddress());
                Connection pc = m.getConnection();
                if (pc == null || pc.isClosed()) continue;
                CVMLong id = m.getID();
                Result res = br.getResults().get(j).withID(id);
                pc.sendResult(res);
                this.interests.remove(h);
                continue;
            }
            catch (Throwable e) {
                log.warn("Exception while sending Result: ", e);
            }
        }
    }

    public int getPort() {
        return this.nio.getPort();
    }

    public void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistPeerData() {
        AStore tempStore = Stores.current();
        try {
            Stores.setCurrent(this.store);
            AMap<Keyword, ACell> peerData = this.peer.toData();
            Ref<AMap<Keyword, ACell>> peerRef = ACell.createPersisted(peerData);
            Hash peerHash = peerRef.getHash();
            this.store.setRootHash(peerHash);
            log.info("Stored peer data for Server with hash: {}", (Object)peerHash.toHexString());
        }
        catch (Throwable e) {
            log.warn("Failed to persist peer state when closing server: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        finally {
            Stores.setCurrent(tempStore);
        }
    }

    @Override
    public void close() {
        if (this.peer != null && Utils.bool(this.getConfig().get(Keywords.PERSIST))) {
            this.persistPeerData();
        }
        SignedData<ACell> signedPeerKey = this.peer.sign(this.peer.getPeerKey());
        Message msg = Message.createGoodBye(signedPeerKey);
        this.manager.broadcast(msg, false);
        this.isRunning = false;
        if (this.updateThread != null) {
            this.updateThread.interrupt();
            try {
                this.updateThread.join(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.receiverThread != null) {
            this.receiverThread.interrupt();
            try {
                this.receiverThread.join(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.manager.close();
        this.nio.close();
    }

    public InetSocketAddress getHostAddress() {
        return this.nio.getHostAddress();
    }

    public AKeyPair getKeyPair() {
        return this.getPeer().getKeyPair();
    }

    public AccountKey getPeerKey() {
        AKeyPair kp = this.getKeyPair();
        if (kp == null) {
            return null;
        }
        return kp.getAccountKey();
    }

    public AStore getStore() {
        return this.store;
    }

    public void raiseServerChange(String reason) {
        if (this.eventHook != null) {
            ServerEvent serverEvent = ServerEvent.create(this, reason);
            this.eventHook.onServerChange(serverEvent);
        }
    }

    public ConnectionManager getConnectionManager() {
        return this.manager;
    }

    public HashMap<Keyword, Object> getConfig() {
        return this.config;
    }

    public Consumer<Message> getReceiveAction() {
        return this.peerReceiveAction;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public boolean isLive() {
        return this.isRunning;
    }
}

