/*
 * Decompiled with CFR 0.152.
 */
package convex.core.transactions;

import convex.core.data.ACell;
import convex.core.data.Address;
import convex.core.data.Format;
import convex.core.data.type.AType;
import convex.core.data.type.Transaction;
import convex.core.lang.Context;

public abstract class ATransaction
extends ACell {
    protected final Address address;
    protected final long sequence;

    protected ATransaction(Address address, long sequence) {
        if (address == null) {
            throw new ClassCastException("Null Address for transaction");
        }
        this.address = address;
        this.sequence = sequence;
    }

    @Override
    public abstract int encode(byte[] var1, int var2);

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLCLong(bs, pos, this.address.longValue());
        pos = Format.writeVLCLong(bs, pos, this.sequence);
        return pos;
    }

    @Override
    public abstract int estimatedEncodingSize();

    public abstract <T extends ACell> Context<T> apply(Context<?> var1);

    public Address getAddress() {
        return this.address;
    }

    public final long getSequence() {
        return this.sequence;
    }

    public abstract Long getMaxJuice();

    @Override
    public final boolean isCVMValue() {
        return false;
    }

    @Override
    public AType getType() {
        return Transaction.INSTANCE;
    }

    public abstract ATransaction withSequence(long var1);

    public abstract ATransaction withAddress(Address var1);

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public ACell toCanonical() {
        return this;
    }
}

