/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.MissingDataException;
import convex.core.store.Stores;
import convex.core.util.Utils;
import java.lang.ref.SoftReference;

public class RefSoft<T extends ACell>
extends Ref<T> {
    protected SoftReference<T> softRef;

    protected RefSoft(SoftReference<T> ref, Hash hash, int flags) {
        super(hash, flags);
        this.softRef = ref;
    }

    protected RefSoft(T value, Hash hash, int flags) {
        this(new SoftReference<T>(value), hash, flags);
    }

    protected RefSoft(Hash hash) {
        this(new SoftReference<Object>(null), hash, 0);
    }

    @Override
    public RefSoft<T> withFlags(int newFlags) {
        return new RefSoft<SoftReference<T>>(this.softRef, this.hash, newFlags);
    }

    public static <T extends ACell> RefSoft<T> create(T value, int flags) {
        Hash hash = Hash.compute(value);
        return new RefSoft<T>(value, hash, flags);
    }

    public static <T extends ACell> RefSoft<T> createForHash(Hash hash) {
        return new RefSoft<T>(hash);
    }

    @Override
    public T getValue() {
        ACell result = (ACell)this.softRef.get();
        if (result == null) {
            Ref storeRef = Stores.current().refForHash(this.hash);
            if (storeRef == null) {
                throw (RuntimeException)Utils.sneakyThrow(new MissingDataException(this.hash));
            }
            result = storeRef.getValue();
            this.softRef = storeRef instanceof RefSoft ? ((RefSoft)storeRef).softRef : new SoftReference<ACell>(result);
        }
        return (T)result;
    }

    @Override
    public boolean isMissing() {
        ACell result = (ACell)this.softRef.get();
        if (result != null) {
            return false;
        }
        Ref storeRef = Stores.current().refForHash(this.hash);
        if (storeRef == null) {
            return true;
        }
        this.softRef = storeRef instanceof RefSoft ? ((RefSoft)storeRef).softRef : new SoftReference(storeRef.getValue());
        return false;
    }

    @Override
    public boolean equalsValue(Ref<T> a) {
        if (a.hash != null) {
            return this.hash.equals(a.hash);
        }
        return Utils.equals(this.getValue(), a.getValue());
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public Hash getHash() {
        return this.hash;
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        if (this.hash == null) {
            throw new InvalidDataException("Hash should never be null in soft ref", this);
        }
        ACell val = (ACell)this.softRef.get();
        boolean embedded = this.isEmbedded();
        if (embedded != Format.isEmbedded(val)) {
            throw new InvalidDataException("Embedded flag [" + embedded + "] inconsistent with value", this);
        }
    }

    @Override
    public Ref<T> withValue(T newValue) {
        if (this.softRef.get() != newValue) {
            return new RefSoft<T>(newValue, this.hash, this.flags);
        }
        return this;
    }

    @Override
    public int estimatedEncodingSize() {
        return this.isEmbedded() ? 140 : 33;
    }
}

