/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import ch.qos.logback.classic.Level;
import convex.api.Convex;
import convex.cli.Account;
import convex.cli.Helpers;
import convex.cli.Key;
import convex.cli.Local;
import convex.cli.Peer;
import convex.cli.Query;
import convex.cli.Status;
import convex.cli.Transaction;
import convex.cli.output.Output;
import convex.cli.peer.SessionItem;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.PFXTools;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.init.Init;
import java.io.File;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="convex", subcommands={Account.class, Key.class, Local.class, Peer.class, Query.class, Status.class, Transaction.class, CommandLine.HelpCommand.class}, mixinStandardHelpOptions=true, usageHelpAutoWidth=true, sortOptions=false, descriptionHeading="%nDescription:%n%n", parameterListHeading="%nParameters:%n", optionListHeading="%nOptions:%n", commandListHeading="%nCommands:%n", description={"Convex Command Line Interface"})
public class Main
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(Main.class);
    private static CommandLine commandLine;
    public Output output;
    @CommandLine.Option(names={"-c", "--config"}, scope=CommandLine.ScopeType.INHERIT, description={"Use the specified config file.%n All parameters to this app can be set by removing the leading '--', and adding a leading 'convex.'.%n So to set the keystore filename you can write 'convex.keystore=my_keystore_filename.dat'%nTo set a sub command such as `./convex peer start index=4` index parameter you need to write 'convex.peer.start.index=4'"})
    private String configFilename;
    @CommandLine.Option(names={"-e", "--etch"}, scope=CommandLine.ScopeType.INHERIT, description={"Convex state storage filename. The default is to use a temporary storage filename."})
    private String etchStoreFilename;
    @CommandLine.Option(names={"-k", "--keystore"}, defaultValue="~/.convex/keystore.pfx", scope=CommandLine.ScopeType.INHERIT, description={"keystore filename. Default: ${DEFAULT-VALUE}"})
    private String keyStoreFilename;
    @CommandLine.Option(names={"-p", "--password"}, scope=CommandLine.ScopeType.INHERIT, description={"Password to read/write to the Keystore"})
    private String password;
    @CommandLine.Option(names={"-s", "--session"}, defaultValue="~/.convex/session.conf", scope=CommandLine.ScopeType.INHERIT, description={"Session filename. Defaults ${DEFAULT-VALUE}"})
    private String sessionFilename;
    @CommandLine.Option(names={"-v", "--verbose"}, scope=CommandLine.ScopeType.INHERIT, description={"Show more verbose log information. You can increase verbosity by using multiple -v or -vvv"})
    private boolean[] verbose = new boolean[0];

    public Main() {
        this.output = new Output();
    }

    @Override
    public void run() {
        CommandLine.usage(new Main(), System.out);
    }

    public static void main(String[] args) {
        Main mainApp = new Main();
        int result = mainApp.execute(args);
        System.exit(result);
    }

    public int execute(String[] args) {
        commandLine = new CommandLine(this).setUsageHelpLongOptionsMaxWidth(40).setUsageHelpWidth(160);
        try {
            commandLine.parseArgs(args);
            this.loadConfig();
        }
        catch (Throwable t) {
            System.err.println("unable to parse arguments " + t);
        }
        ch.qos.logback.classic.Logger parentLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        Level[] verboseLevels = new Level[]{Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE, Level.ALL};
        parentLogger.setLevel(Level.WARN);
        if (this.verbose.length > 0 && this.verbose.length <= verboseLevels.length) {
            parentLogger.setLevel(verboseLevels[this.verbose.length]);
            log.info("set level to {}", (Object)parentLogger.getLevel());
        }
        int result = 0;
        try {
            result = commandLine.execute(args);
            this.output.writeToStream(commandLine.getOut());
        }
        catch (Throwable t) {
            log.error("Error executing command line: {}", (Object)t.getMessage());
            return 2;
        }
        return result;
    }

    protected void loadConfig() {
        String filename;
        File configFile;
        if (this.configFilename != null && !this.configFilename.isEmpty() && (configFile = new File(filename = Helpers.expandTilde(this.configFilename))).exists()) {
            CommandLine.PropertiesDefaultProvider defaultProvider = new CommandLine.PropertiesDefaultProvider(configFile);
            commandLine.setDefaultValueProvider(defaultProvider);
        }
    }

    public String getSessionFilename() {
        if (this.sessionFilename != null) {
            return Helpers.expandTilde(this.sessionFilename.strip());
        }
        return null;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKeyStoreFilename() {
        if (this.keyStoreFilename != null) {
            return Helpers.expandTilde(this.keyStoreFilename).strip();
        }
        return null;
    }

    public String getEtchStoreFilename() {
        if (this.etchStoreFilename != null) {
            return Helpers.expandTilde(this.etchStoreFilename).strip();
        }
        return null;
    }

    public KeyStore loadKeyStore(boolean isCreate) throws Error {
        KeyStore keyStore;
        block5: {
            keyStore = null;
            if (this.password == null || this.password.isEmpty()) {
                throw new Error("You need to provide a keystore password");
            }
            File keyFile = new File(this.getKeyStoreFilename());
            try {
                if (keyFile.exists()) {
                    keyStore = PFXTools.loadStore(keyFile, this.password);
                    break block5;
                }
                if (isCreate) {
                    Helpers.createPath(keyFile);
                    keyStore = PFXTools.createStore(keyFile, this.password);
                    break block5;
                }
                throw new Error("Cannot find keystore file " + keyFile.getCanonicalPath());
            }
            catch (Throwable t) {
                new Error(t);
            }
        }
        return keyStore;
    }

    public AKeyPair loadKeyFromStore(String publicKey, int indexKey) throws Error {
        AKeyPair keyPair = null;
        String publicKeyClean = "";
        if (publicKey != null) {
            publicKeyClean = publicKey.toLowerCase().replaceAll("^0x", "").strip();
        }
        if (publicKeyClean.isEmpty() && indexKey <= 0) {
            return null;
        }
        Object searchText = publicKeyClean;
        if (indexKey > 0) {
            searchText = (String)searchText + " " + indexKey;
        }
        if (this.password == null || this.password.isEmpty()) {
            throw new Error("You need to provide a keystore password");
        }
        File keyFile = new File(this.getKeyStoreFilename());
        try {
            if (!keyFile.exists()) {
                throw new Error("Cannot find keystore file " + keyFile.getCanonicalPath());
            }
            KeyStore keyStore = PFXTools.loadStore(keyFile, this.password);
            int counter = 1;
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (counter == indexKey || alias.indexOf(publicKeyClean) == 0) {
                    log.trace("found keypair " + indexKey + " " + counter + " " + alias + " " + publicKeyClean + " " + alias.indexOf(publicKeyClean));
                    keyPair = PFXTools.getKeyPair(keyStore, alias, this.password);
                    break;
                }
                ++counter;
            }
        }
        catch (Throwable t) {
            throw new Error("Cannot load key store " + t);
        }
        if (keyPair == null) {
            throw new Error("Cannot find key in keystore '" + (String)searchText + "'");
        }
        return keyPair;
    }

    public Convex connectToSessionPeer(String hostname, int port, Address address, AKeyPair keyPair) throws Error {
        Convex convex = null;
        try {
            SessionItem item;
            if (port == 0 && (item = Helpers.getSessionItem(this.getSessionFilename())) != null) {
                port = item.getPort();
            }
            if (port == 0) {
                throw new Error("Cannot find a local port or you have not set a valid port number");
            }
            InetSocketAddress host = new InetSocketAddress(hostname.strip(), port);
            convex = Convex.connect(host, address, keyPair);
        }
        catch (Throwable t) {
            throw new Error("Cannot connect to a local peer " + t);
        }
        return convex;
    }

    public Convex connectAsPeer(int peerIndex) throws Error {
        Convex convex = null;
        try {
            SessionItem item = Helpers.getSessionItem(this.getSessionFilename(), peerIndex);
            AccountKey peerKey = item.getAccountKey();
            log.debug("peer public key {}", (Object)peerKey.toHexString());
            AKeyPair keyPair = this.loadKeyFromStore(peerKey.toHexString(), 0);
            log.debug("peer key pair {}", (Object)keyPair.getAccountKey().toHexString());
            Address address = Init.getGenesisPeerAddress(peerIndex);
            log.debug("peer address {}", (Object)address);
            InetSocketAddress host = item.getHostAddress();
            log.debug("connect to peer {}", (Object)host);
            convex = Convex.connect(host, address, keyPair);
        }
        catch (Throwable t) {
            throw new Error("Cannot connect as a peer " + t);
        }
        return convex;
    }

    public List<AKeyPair> generateKeyPairs(int count) throws Error {
        ArrayList<AKeyPair> keyPairList = new ArrayList<AKeyPair>(count);
        for (int index = 0; index < count; ++index) {
            AKeyPair keyPair = AKeyPair.generate();
            keyPairList.add(keyPair);
            this.addKeyPairToStore(keyPair);
        }
        return keyPairList;
    }

    public void addKeyPairToStore(AKeyPair keyPair) {
        String password = this.getPassword();
        if (password == null) {
            throw new Error("You need to provide a keystore password");
        }
        File keyFile = new File(this.getKeyStoreFilename());
        KeyStore keyStore = null;
        try {
            if (keyFile.exists()) {
                keyStore = PFXTools.loadStore(keyFile, password);
            } else {
                Helpers.createPath(keyFile);
                keyStore = PFXTools.createStore(keyFile, password);
            }
        }
        catch (Throwable t) {
            throw new Error("Cannot load key store: " + t);
        }
        try {
            PFXTools.setKeyPair(keyStore, keyPair, password);
        }
        catch (Throwable t) {
            throw new Error("Cannot store the key to the key store " + t);
        }
        try {
            PFXTools.saveStore(keyStore, keyFile, password);
        }
        catch (Throwable t) {
            throw new Error("Cannot save the key store file " + t);
        }
    }

    int[] getPortList(String[] ports, int count) throws NumberFormatException {
        Pattern rangePattern = Pattern.compile("([0-9]+)\\s*-\\s*([0-9]*)");
        List<String> portTextList = Helpers.splitArrayParameter(ports);
        ArrayList<Integer> portList = new ArrayList<Integer>();
        int countLeft = count;
        for (int index = 0; index < portTextList.size() && countLeft > 0; ++index) {
            String item = portTextList.get(index);
            Matcher matcher = rangePattern.matcher(item);
            if (matcher.matches()) {
                int portFrom = Integer.parseInt(matcher.group(1));
                int portTo = portFrom + count + 1;
                if (!matcher.group(2).isEmpty()) {
                    portTo = Integer.parseInt(matcher.group(2));
                }
                for (int portIndex = portFrom; portIndex <= portTo && countLeft > 0; ++portIndex, --countLeft) {
                    portList.add(portIndex);
                }
                continue;
            }
            if (item.strip().length() == 0) continue;
            portList.add(Integer.parseInt(item));
            --countLeft;
        }
        return portList.stream().mapToInt(Integer::intValue).toArray();
    }

    void showError(Throwable t) {
        log.error(t.getMessage());
        if (this.verbose.length > 0) {
            t.printStackTrace();
        }
    }
}

