/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.world;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.pxstudios.minelib.common.location.point.Point3D;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import net.pxstudios.minelib.world.rule.WorldGameRule;
import net.pxstudios.minelib.world.rule.WorldGameRuleType;
import net.pxstudios.minelib.world.time.WorldTimeType;
import net.pxstudios.minelib.world.weather.WorldWeatherType;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class WrapperBukkitWorld {
    private final Set<Flag> flagsSet = new HashSet<Flag>();
    private final MinecraftPlugin plugin;
    private final World bukkit;

    public final String getName() {
        return this.bukkit.getName();
    }

    public final Set<Flag> getActiveFlags() {
        return Collections.unmodifiableSet(this.flagsSet);
    }

    public final boolean addFlag(@NonNull Flag flag) {
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        return this.flagsSet.add(flag);
    }

    public final boolean removeFlag(@NonNull Flag flag) {
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        return this.flagsSet.remove((Object)flag);
    }

    public final boolean hasFlag(@NonNull Flag flag) {
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        return this.flagsSet.contains((Object)flag);
    }

    public final void setSpawnLocation(int x, int y, int z) {
        this.bukkit.setSpawnLocation(x, y, z);
    }

    public final void setSpawnLocation(double x, double y, double z) {
        this.setSpawnLocation((int)x, (int)y, (int)z);
    }

    public final void setSpawnLocation(@NonNull Vector vector) {
        if (vector == null) {
            throw new NullPointerException("vector is marked non-null but is null");
        }
        this.setSpawnLocation(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    public final void setSpawnLocation(@NonNull Point3D point3D) {
        if (point3D == null) {
            throw new NullPointerException("point3D is marked non-null but is null");
        }
        this.setSpawnLocation(point3D.toVector());
    }

    public final void setSpawnLocation(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.setSpawnLocation(new Point3D(location));
    }

    public final void setSpawnLocation(@NonNull Block block) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        this.setSpawnLocation(block.getLocation());
    }

    public final void setGameRuleValue(WorldGameRuleType type, String value) {
        this.bukkit.setGameRuleValue(type.getName(), value);
    }

    public final void setGameRuleValue(WorldGameRuleType type, boolean value) {
        this.bukkit.setGameRuleValue(type.getName(), Boolean.toString(value));
    }

    public final void setGameRuleValue(WorldGameRuleType type, int value) {
        this.bukkit.setGameRuleValue(type.getName(), Integer.toString(value));
    }

    public final void setGameRuleValue(WorldGameRuleType type, double value) {
        this.bukkit.setGameRuleValue(type.getName(), Double.toString(value));
    }

    public final void setDefaultGameRuleValue(WorldGameRuleType type) {
        this.setGameRuleValue(type, type.getDefaultValue());
    }

    public final WorldGameRule getGameRuleValue(WorldGameRuleType type) {
        return new WorldGameRule(type, this.bukkit.getGameRuleValue(type.getName()));
    }

    public final void setWeatherByBukkit(WeatherType weather) {
        this.bukkit.setWeatherDuration(weather == WeatherType.CLEAR ? 0 : 1);
    }

    public final void setWeather(WorldWeatherType weather) {
        boolean isThundering;
        boolean bl = isThundering = weather == WorldWeatherType.THUNDER;
        if (isThundering) {
            weather = WorldWeatherType.RAIN;
        }
        this.bukkit.setWeatherDuration(weather.ordinal());
        if (isThundering) {
            this.bukkit.setThundering(true);
            this.bukkit.setThunderDuration(1);
        }
    }

    public final void setTime(WorldTimeType timeType) {
        this.bukkit.setTime(timeType.getMinecraftTicks());
    }

    public final void setFullTime(WorldTimeType timeType) {
        this.bukkit.setFullTime(timeType.getMinecraftTicks());
    }

    public final Collection<Entity> getNearbyEntities(Location origin, double radiusX, double radiusY, double radiusZ) {
        return this.bukkit.getNearbyEntities(origin, radiusX, radiusY, radiusZ);
    }

    public final Collection<Entity> getNearbyEntities(Point3D origin, double radiusX, double radiusY, double radiusZ) {
        Location location = this.plugin.getMineLibrary().getLocationApi().toLocation(this.bukkit, origin);
        return this.getNearbyEntities(location, radiusX, radiusY, radiusZ);
    }

    public final Collection<Entity> getNearbyEntities(EntityType entityType, Location origin, double radiusX, double radiusY, double radiusZ) {
        return this.getNearbyEntities(origin, radiusX, radiusY, radiusZ).stream().filter(entity -> entity.getType() == entityType).collect(Collectors.toList());
    }

    public final Collection<Entity> getNearbyEntities(EntityType entityType, Point3D origin, double radiusX, double radiusY, double radiusZ) {
        return this.getNearbyEntities(origin, radiusX, radiusY, radiusZ).stream().filter(entity -> entity.getType() == entityType).collect(Collectors.toList());
    }

    public final Collection<Entity> getNearbyEntities(Location origin, double radius) {
        return this.getNearbyEntities(origin, radius, radius, radius);
    }

    public final Collection<Entity> getNearbyEntities(Point3D origin, double radius) {
        return this.getNearbyEntities(origin, radius, radius, radius);
    }

    public final Collection<Entity> getNearbyEntities(EntityType entityType, Location origin, double radius) {
        return this.getNearbyEntities(entityType, origin, radius, radius, radius);
    }

    public final Collection<Entity> getNearbyEntities(EntityType entityType, Point3D origin, double radius) {
        return this.getNearbyEntities(entityType, origin, radius, radius, radius);
    }

    public final Collection<Entity> getNearbyEntities(Location origin) {
        return this.getNearbyEntities(origin, 1.0);
    }

    public final Collection<Entity> getNearbyEntities(Point3D origin) {
        return this.getNearbyEntities(origin, 1.0);
    }

    public final Collection<Entity> getNearbyEntities(EntityType entityType, Location origin) {
        return this.getNearbyEntities(entityType, origin, 1.0);
    }

    public final Collection<Entity> getNearbyEntities(EntityType entityType, Point3D origin) {
        return this.getNearbyEntities(entityType, origin, 1.0);
    }

    public final Collection<Player> getNearbyPlayers(Location origin, double radiusX, double radiusY, double radiusZ) {
        return this.getNearbyEntities(EntityType.PLAYER, origin, radiusX, radiusY, radiusZ).stream().map(entity -> (Player)entity).collect(Collectors.toList());
    }

    public final Collection<Player> getNearbyPlayers(Point3D origin, double radiusX, double radiusY, double radiusZ) {
        return this.getNearbyEntities(EntityType.PLAYER, origin, radiusX, radiusY, radiusZ).stream().map(entity -> (Player)entity).collect(Collectors.toList());
    }

    public final Collection<Player> getNearbyPlayers(Location origin, double radius) {
        return this.getNearbyPlayers(origin, radius, radius, radius);
    }

    public final Collection<Player> getNearbyPlayers(Point3D origin, double radius) {
        return this.getNearbyPlayers(origin, radius, radius, radius);
    }

    public final Collection<Player> getNearbyPlayers(Location origin) {
        return this.getNearbyPlayers(origin, 1.0);
    }

    public final Collection<Player> getNearbyPlayers(Point3D origin) {
        return this.getNearbyPlayers(origin, 1.0);
    }

    public final List<Player> getPlayers() {
        return this.bukkit.getPlayers();
    }

    public final List<Entity> getEntities() {
        return this.bukkit.getEntities();
    }

    public final List<LivingEntity> getLivingEntities() {
        return this.bukkit.getLivingEntities();
    }

    public final <T extends Entity> Collection<T> getEntitiesByClass(Class<T> cls) {
        return this.bukkit.getEntitiesByClass(cls);
    }

    @SafeVarargs
    public final Collection<Entity> getEntitiesByClasses(Class<? extends Entity> ... cls) {
        return this.bukkit.getEntitiesByClasses((Class[])cls);
    }

    public final Collection<Entity> getEntitiesByType(EntityType entityType) {
        return this.getEntitiesByClasses(entityType.getEntityClass());
    }

    public final Location getLocationAt(double x, double y, double z, float yaw, float pitch) {
        return new Location(this.bukkit, x, y, z, yaw, pitch);
    }

    public final Location getLocationAt(double x, double y, double z) {
        return this.getLocationAt(x, y, z, 0.0f, 0.0f);
    }

    public final Location getLocationAt(Vector vector) {
        return this.plugin.getMineLibrary().getLocationApi().toLocation(this.bukkit, vector);
    }

    public final Location getLocationAt(Point3D point3D) {
        return this.getLocationAt(point3D.toVector());
    }

    public final Block getBlockAt(int x, int y, int z) {
        return this.getLocationAt(x, y, z).getBlock();
    }

    public final Block getBlockAt(Vector vector) {
        return this.getLocationAt(vector).getBlock();
    }

    public final Block getBlockAt(Point3D point3D) {
        return this.getLocationAt(point3D).getBlock();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WrapperBukkitWorld) {
            if (obj == this) {
                return true;
            }
            return ((WrapperBukkitWorld)obj).getName().equals(this.getName());
        }
        if (obj instanceof World) {
            return ((World)obj).getName().equals(this.getName());
        }
        return false;
    }

    WrapperBukkitWorld(MinecraftPlugin plugin, World bukkit) {
        this.plugin = plugin;
        this.bukkit = bukkit;
    }

    public World getBukkit() {
        return this.bukkit;
    }

    public static enum Flag {
        PLAYER_SPAWN_TELEPORT_ON_JOIN,
        PLAYER_SPAWN_TELEPORT_ON_CHANGED,
        PLAYER_SPAWN_TELEPORT_ON_RESPAWN;

    }
}

