/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.subscription;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.pxstudios.minelib.subscription.EventSubscribeHelper;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;

public final class SingleEventBuilder<T extends Event> {
    private final EventSubscribeHelper<T> eventSubscribeHelper;
    private final Class<T> eventClass;
    private final EventPriority priority;
    private final Map<Predicate<T>, Boolean> predicatesUnregisterMap = new HashMap<Predicate<T>, Boolean>();
    private boolean ignoreCancelled;
    private Consumer<T> handler;

    public SingleEventBuilder<T> withIgnoreCancelled() {
        this.ignoreCancelled = true;
        return this;
    }

    public SingleEventBuilder<T> withPredication(Predicate<T> eventFilter) {
        this.predicatesUnregisterMap.put(eventFilter, false);
        return this;
    }

    public SingleEventBuilder<T> withExpiration(Predicate<T> eventFilter) {
        this.predicatesUnregisterMap.put(eventFilter, true);
        return this;
    }

    public SingleEventBuilder<T> withExpirationTime(long delay, TimeUnit timeUnit) {
        return this.withExpiration(event -> System.currentTimeMillis() - this.eventSubscribeHelper.getRegisteredTimeMillis() >= timeUnit.toMillis(delay));
    }

    public SingleEventBuilder<T> withMaxUseCount(int maxCountUse) {
        return this.withExpiration(event -> this.eventSubscribeHelper.getUsingCounter() >= (long)maxCountUse);
    }

    public void complete(Consumer<T> eventHandler) {
        this.handler = eventHandler;
        this.eventSubscribeHelper.registerInBukkit(this);
    }

    EventSubscribeHelper<T> getEventSubscribeHelper() {
        return this.eventSubscribeHelper;
    }

    Class<T> getEventClass() {
        return this.eventClass;
    }

    EventPriority getPriority() {
        return this.priority;
    }

    Map<Predicate<T>, Boolean> getPredicatesUnregisterMap() {
        return this.predicatesUnregisterMap;
    }

    boolean isIgnoreCancelled() {
        return this.ignoreCancelled;
    }

    Consumer<T> getHandler() {
        return this.handler;
    }

    SingleEventBuilder(EventSubscribeHelper<T> eventSubscribeHelper, Class<T> eventClass, EventPriority priority) {
        this.eventSubscribeHelper = eventSubscribeHelper;
        this.eventClass = eventClass;
        this.priority = priority;
    }
}

