/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.subscription;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Predicate;
import lombok.NonNull;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import net.pxstudios.minelib.subscription.SingleEventBuilder;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class EventSubscribeHelper<T extends Event>
implements Listener,
EventExecutor {
    private final MinecraftPlugin plugin;
    private SingleEventBuilder<T> singleEventBuilder;
    private long usingCounter;
    private boolean active;
    private long registeredTimeMillis;

    public void execute(Listener listener, Event event) {
        if (!this.active) {
            EventSubscribeHelper.unregisterListener(event.getClass(), listener);
            return;
        }
        if (this.singleEventBuilder == null) {
            return;
        }
        if (this.singleEventBuilder.getEventClass() != event.getClass()) {
            return;
        }
        Event instance = event;
        for (Map.Entry<Predicate<T>, Boolean> entry : this.singleEventBuilder.getPredicatesUnregisterMap().entrySet()) {
            Predicate<Event> predicate = entry.getKey();
            boolean unregisterFlag = entry.getValue();
            if (!predicate.test(instance)) continue;
            if (unregisterFlag) {
                this.active = false;
            }
            return;
        }
        this.singleEventBuilder.getHandler().accept(instance);
        ++this.usingCounter;
    }

    public void registerInBukkit(@NonNull SingleEventBuilder<T> singleEventBuilder) {
        if (singleEventBuilder == null) {
            throw new NullPointerException("singleEventBuilder is marked non-null but is null");
        }
        this.registeredTimeMillis = System.currentTimeMillis();
        this.singleEventBuilder = singleEventBuilder;
        this.active = true;
        this.plugin.getServer().getPluginManager().registerEvent(singleEventBuilder.getEventClass(), (Listener)this, singleEventBuilder.getPriority(), (EventExecutor)this, (Plugin)this.plugin);
    }

    private static void unregisterListener(Class<? extends Event> eventClass, Listener listener) {
        Method getHandlerListMethod = eventClass.getMethod("getHandlerList", new Class[0]);
        HandlerList handlerList = (HandlerList)getHandlerListMethod.invoke(null, new Object[0]);
        handlerList.unregister(listener);
    }

    EventSubscribeHelper(MinecraftPlugin plugin) {
        this.plugin = plugin;
    }

    public long getUsingCounter() {
        return this.usingCounter;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getRegisteredTimeMillis() {
        return this.registeredTimeMillis;
    }
}

