/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.registry.provider.type;

import java.lang.reflect.Method;
import java.util.function.Consumer;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import net.pxstudios.minelib.registry.BukkitRegistryObject;
import net.pxstudios.minelib.registry.provider.BukkitRegistryObjectProvider;
import net.pxstudios.minelib.subscription.EventsSubscriber;
import net.pxstudios.minelib.subscription.SingleEventBuilder;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class EventListenerRegistryObjectProvider
implements BukkitRegistryObjectProvider<Listener> {
    @Override
    public void fireRegister(MinecraftPlugin plugin, Listener obj) {
        if (obj != null) {
            plugin.getServer().getPluginManager().registerEvents(obj, (Plugin)plugin);
        }
    }

    @Override
    public Listener newObjectInstance(MinecraftPlugin plugin, BukkitRegistryObject<Listener> bukkitRegistryObject) {
        for (Method method : bukkitRegistryObject.getClass().getMethods()) {
            Class<Event> parameter;
            EventHandler eventHandler;
            if (method.getParameterCount() != 1 || (eventHandler = method.getDeclaredAnnotation(EventHandler.class)) == null || !(parameter = method.getParameterTypes()[0]).isAssignableFrom(Event.class)) continue;
            this.subscribe(plugin.getMineLibrary().getEventsSubscriber(), parameter, eventHandler, event -> {
                try {
                    method.invoke((Object)bukkitRegistryObject, event);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            });
        }
        return null;
    }

    private <E extends Event> void subscribe(EventsSubscriber eventsSubscriber, Class<E> cls, EventHandler eventHandler, Consumer<E> completable) {
        SingleEventBuilder<E> singleEventBuilder = eventsSubscriber.subscribe(cls, eventHandler.priority());
        if (eventHandler.ignoreCancelled()) {
            singleEventBuilder.withIgnoreCancelled();
        }
        singleEventBuilder.complete(completable);
    }
}

