/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.registry;

import java.util.function.Function;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import net.pxstudios.minelib.registry.BukkitRegistryManager;
import net.pxstudios.minelib.registry.provider.BukkitRegistryObjectProvider;

public class BukkitRegistryObject<T> {
    private Function<BukkitRegistryManager, BukkitRegistryObjectProvider<T>> providerFunction;

    private T newInstance(BukkitRegistryManager manager, MinecraftPlugin plugin) {
        BukkitRegistryObjectProvider<T> provider = this.providerFunction.apply(manager);
        if (provider != null) {
            return provider.newObjectInstance(plugin, this);
        }
        return null;
    }

    void register(BukkitRegistryManager manager, MinecraftPlugin plugin) {
        BukkitRegistryObjectProvider<T> provider = this.providerFunction.apply(manager);
        if (provider != null) {
            provider.fireRegister(plugin, this.newInstance(manager, plugin));
        }
    }

    public BukkitRegistryObject(Function<BukkitRegistryManager, BukkitRegistryObjectProvider<T>> providerFunction) {
        this.providerFunction = providerFunction;
    }

    void setProviderFunction(Function<BukkitRegistryManager, BukkitRegistryObjectProvider<T>> providerFunction) {
        this.providerFunction = providerFunction;
    }
}

