/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.registry;

import java.util.HashMap;
import java.util.Map;
import net.pxstudios.minelib.command.type.AbstractContextCommand;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import net.pxstudios.minelib.registry.BukkitRegistryObject;
import net.pxstudios.minelib.registry.provider.BukkitRegistryObjectProvider;
import net.pxstudios.minelib.registry.provider.type.CommandRegistryObjectProvider;
import net.pxstudios.minelib.registry.provider.type.EventListenerRegistryObjectProvider;
import org.bukkit.event.Listener;

public final class BukkitRegistryManager {
    private final MinecraftPlugin plugin;
    private final Map<Class<?>, BukkitRegistryObjectProvider<?>> providersByTypeMap = new HashMap();

    public <T> BukkitRegistryObjectProvider<T> getProvider(Class<T> cls) {
        return this.providersByTypeMap.get(cls);
    }

    public <T> void addProvider(Class<T> cls, BukkitRegistryObjectProvider<T> provider) {
        this.providersByTypeMap.put(cls, provider);
    }

    public void register(Class<? extends BukkitRegistryObject<?>> cls) {
        BukkitRegistryObject<?> bukkitRegistryObject = null;
        try {
            bukkitRegistryObject = cls.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bukkitRegistryObject != null) {
            bukkitRegistryObject.register(this, this.plugin);
        }
    }

    public void addDefaultProviders() {
        this.addProvider(AbstractContextCommand.class, new CommandRegistryObjectProvider());
        this.addProvider(Listener.class, new EventListenerRegistryObjectProvider());
    }

    public BukkitRegistryManager(MinecraftPlugin plugin) {
        this.plugin = plugin;
    }
}

