/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.plugin;

import java.util.logging.Level;
import net.pxstudios.minelib.MineLibrary;
import net.pxstudios.minelib.event.plugin.MLMinecraftPluginDisableEvent;
import net.pxstudios.minelib.event.plugin.MLMinecraftPluginEnableEvent;
import org.bukkit.ChatColor;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class MinecraftPlugin
extends JavaPlugin {
    private long onLoadTimeMillis;
    private MineLibrary mineLibrary;

    public final void log(Level level, String message, Object ... placeholders) {
        this.getLogger().log(level, ChatColor.WHITE + String.format(message, placeholders));
    }

    public final void log(String message, Object ... placeholders) {
        this.log(Level.INFO, message, placeholders);
    }

    public final void log(Level level, Object message) {
        this.log(level, (Object)(message != null ? message.toString() : "null"));
    }

    public final void log(Object message) {
        this.log(Level.INFO, message);
    }

    public void postLoad(MineLibrary mineLibrary) {
    }

    public void postDisable(MineLibrary mineLibrary) {
    }

    public abstract void postEnable(MineLibrary var1);

    public final void onLoad() {
        this.mineLibrary = new MineLibrary();
        this.onLoadTimeMillis = System.currentTimeMillis();
        this.log("Initializing library data`s & api`s...");
        this.mineLibrary.init(this);
        this.postLoad(this.mineLibrary);
    }

    public final void onEnable() {
        this.log("Running automatically memory cleanup task...");
        this.mineLibrary.runAutoGarbageCollector();
        this.log("Init custom server-motd api...");
        this.mineLibrary.getServerMotdApi().initDefaults(this.getServer());
        this.log(ChatColor.GREEN + "MineLibrary was success enabled (%sms)", System.currentTimeMillis() - this.onLoadTimeMillis);
        this.postEnable(this.mineLibrary);
        this.mineLibrary.getEventsSubscriber().callEvent(new MLMinecraftPluginEnableEvent(this.mineLibrary, this));
    }

    public final void onDisable() {
        this.postDisable(this.mineLibrary);
        this.mineLibrary.getEventsSubscriber().callEvent(new MLMinecraftPluginDisableEvent(this.mineLibrary, this));
        this.mineLibrary = null;
    }

    public MineLibrary getMineLibrary() {
        return this.mineLibrary;
    }
}

