/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.nms;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import net.pxstudios.minelib.nms.NmsWrapper;
import net.pxstudios.minelib.nms.WrapperNmsBlockData;
import net.pxstudios.minelib.nms.WrapperNmsChunk;
import net.pxstudios.minelib.nms.WrapperNmsWorld;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.material.MaterialData;

public final class NmsHelper {
    public static final Cache<Object, Object> objectsHandlesCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private static final Map<Object, NmsWrapper> wrappersByHandleMap = new ConcurrentHashMap<Object, NmsWrapper>();
    public static final String NMS_PACKAGE_VERSION = Bukkit.getServer().getClass().getName().split("\\.")[3];
    public static final String NMS_VERSION = NMS_PACKAGE_VERSION.substring(1, 3).replace("_", ".");
    public static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final Class<?> PLAYER_CHUNK_MAP_CLASS = NmsHelper.getNmsType("PlayerChunkMap");
    public static final Class<?> CHUNK_SECTION_CLASS = NmsHelper.getNmsType("ChunkSection");
    public static final Class<?> BLOCK_DATA_CLASS = NmsHelper.getNmsType("IBlockData");
    public static final Class<?> BLOCK_CLASS = NmsHelper.getNmsType("Block");
    public static final Class<?> CHUNK_CLASS = NmsHelper.getNmsType("Chunk");
    public static final Class<?> WORLD_SERVER_CLASS = NmsHelper.getNmsType("WorldServer");
    public static final Class<?> WORLD_PROVIDER_CLASS = NmsHelper.getNmsType("WorldProvider");
    public static final MethodHandle CONSTRUCTOR_CHUCK_SECTION;
    public static final MethodHandle METHOD_SET_BLOCK_TYPE;
    public static final MethodHandle METHOD_GET_CHUNK_SECTIONS;
    public static final MethodHandle METHOD_GET_CHUNK_AT;
    public static final MethodHandle METHOD_GET_BLOCK_DATA;

    public static WrapperNmsWorld wrap(@NonNull World world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        return (WrapperNmsWorld)wrappersByHandleMap.computeIfAbsent(world, f -> new WrapperNmsWorld(world));
    }

    public static WrapperNmsChunk wrap(@NonNull Chunk chunk) {
        if (chunk == null) {
            throw new NullPointerException("chunk is marked non-null but is null");
        }
        return (WrapperNmsChunk)wrappersByHandleMap.computeIfAbsent(chunk, f -> new WrapperNmsChunk(chunk));
    }

    public static WrapperNmsBlockData wrap(@NonNull MaterialData materialData) {
        if (materialData == null) {
            throw new NullPointerException("materialData is marked non-null but is null");
        }
        return (WrapperNmsBlockData)wrappersByHandleMap.computeIfAbsent(materialData, f -> new WrapperNmsBlockData(materialData));
    }

    public static Class<?> getNmsType(@NonNull String className) {
        if (className == null) {
            throw new NullPointerException("className is marked non-null but is null");
        }
        return Class.forName("net.minecraft.server." + NMS_PACKAGE_VERSION + "." + className);
    }

    public static Object getNmsHandle(Object src) {
        objectsHandlesCache.cleanUp();
        ConcurrentMap asMap = objectsHandlesCache.asMap();
        if (asMap.containsKey(src)) {
            return asMap.get(src);
        }
        Object handle = src.getClass().getDeclaredMethod("getHandle", new Class[0]).invoke(src, new Object[0]);
        objectsHandlesCache.put(src, handle);
        return handle;
    }

    public static Object getNmsBlockData(MaterialData materialData) {
        return METHOD_GET_BLOCK_DATA.invoke(materialData.getItemTypeId() + (materialData.getData() << 12));
    }

    public static Object getNmsChunkAt(@NonNull Object nmsWorld, int x, int z) {
        if (nmsWorld == null) {
            throw new NullPointerException("nmsWorld is marked non-null but is null");
        }
        return METHOD_GET_CHUNK_AT.invoke(nmsWorld, x, z);
    }

    public static void invokeSetFastBlock(Object src, int x, int y, int z, Object blockData) {
        METHOD_SET_BLOCK_TYPE.invoke(src, x, y, z, blockData);
    }

    private NmsHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        try {
            CONSTRUCTOR_CHUCK_SECTION = LOOKUP.findConstructor(CHUNK_SECTION_CLASS, MethodType.methodType(Void.TYPE, Integer.TYPE, Boolean.TYPE));
            METHOD_SET_BLOCK_TYPE = LOOKUP.findVirtual(CHUNK_SECTION_CLASS, "setType", MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, BLOCK_DATA_CLASS));
            METHOD_GET_CHUNK_SECTIONS = LOOKUP.findVirtual(CHUNK_CLASS, "getSections", MethodType.methodType(Array.newInstance(CHUNK_SECTION_CLASS, 16).getClass()));
            METHOD_GET_CHUNK_AT = LOOKUP.findVirtual(WORLD_SERVER_CLASS, "getChunkAt", MethodType.methodType(CHUNK_CLASS, Integer.TYPE, Integer.TYPE));
            METHOD_GET_BLOCK_DATA = LOOKUP.findStatic(BLOCK_CLASS, "getByCombinedId", MethodType.methodType(BLOCK_DATA_CLASS, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

