/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.motd;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import lombok.NonNull;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.event.EventPriority;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.util.CachedServerIcon;

public final class ServerMotdApi {
    private final MinecraftPlugin plugin;
    private Server server;
    private CachedServerIcon serverIcon;
    private String motd;
    private int maxPlayers;
    private char motdColorAltChar;

    public void initDefaults(@NonNull Server server) {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        this.server = server;
        this.motdColorAltChar = (char)38;
        this.setDefaultMotd();
        this.setDefaultMaxPlayers();
        this.setDefaultServerIcon();
    }

    private void checkServerNullable() {
        if (this.server == null) {
            throw new NullPointerException("server");
        }
    }

    public void enableApiEvents() {
        this.plugin.getMineLibrary().getEventsSubscriber().subscribe(ServerListPingEvent.class, EventPriority.HIGHEST).withPredication(event -> this.server != null).complete(event -> {
            event.setServerIcon(this.serverIcon);
            event.setMaxPlayers(this.maxPlayers);
            event.setMotd(ChatColor.translateAlternateColorCodes((char)this.motdColorAltChar, (String)this.motd));
        });
    }

    public void setServerIcon(@NonNull BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new NullPointerException("bufferedImage is marked non-null but is null");
        }
        this.checkServerNullable();
        try {
            this.serverIcon = this.server.loadServerIcon(bufferedImage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setServerIcon(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.setServerIcon(ImageIO.read(file));
    }

    public void setServerIcon(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.setServerIcon(path.toFile());
    }

    public void setServerIcon(@NonNull URL url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.setServerIcon(ImageIO.read(url));
    }

    public void setServerIcon(@NonNull InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        this.setServerIcon(ImageIO.read(inputStream));
    }

    public void setDefaultServerIcon() {
        this.setServerIcon(this.server.getWorldContainer().toPath().resolve("server-icon.png").toFile());
    }

    public void setMotd(@NonNull String motd) {
        if (motd == null) {
            throw new NullPointerException("motd is marked non-null but is null");
        }
        this.checkServerNullable();
        this.motd = motd;
    }

    public void setMotd(@NonNull Iterable<String> motd) {
        if (motd == null) {
            throw new NullPointerException("motd is marked non-null but is null");
        }
        this.setMotd(String.join((CharSequence)"\n", motd));
    }

    public void setDefaultMotd() {
        this.checkServerNullable();
        this.setMotd(this.server.getMotd());
    }

    public void setMaxPlayers(int maxPlayers) {
        this.checkServerNullable();
        this.maxPlayers = maxPlayers;
    }

    public void setDefaultMaxPlayers() {
        this.checkServerNullable();
        this.setMaxPlayers(this.server.getMaxPlayers());
    }

    public ServerMotdApi(MinecraftPlugin plugin) {
        this.plugin = plugin;
    }

    public void setMotdColorAltChar(char motdColorAltChar) {
        this.motdColorAltChar = motdColorAltChar;
    }
}

