/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.gui;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import net.pxstudios.minelib.event.bukkit.inventory.MLInventoryClickEvent;
import net.pxstudios.minelib.gui.GuiItem;
import net.pxstudios.minelib.gui.provider.GuiProvider;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class Gui {
    private final MinecraftPlugin plugin;
    private final GuiProvider provider;
    private final Map<Player, Inventory> inventoryByPlayersMap = new HashMap<Player, Inventory>();
    private final Map<Player, GuiProvider.DrawingSession> sessionByPlayersMap = new HashMap<Player, GuiProvider.DrawingSession>();

    Gui initialize() {
        this.provider.setPlugin(this.plugin);
        this.provider.setGui(this);
        return this;
    }

    private Inventory getBukkitGui(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.inventoryByPlayersMap.get(player);
    }

    public final boolean isOpened(Player player) {
        return this.getBukkitGui(player) != null;
    }

    private void updateGui0(Player player, Inventory bukkit) {
        GuiProvider.DrawingSession drawingSession = this.provider.createDrawingSession();
        this.provider.draw(player, drawingSession);
        this.provider.setup(bukkit, drawingSession);
        if (this.sessionByPlayersMap.put(player, drawingSession) == null) {
            player.openInventory(bukkit);
        }
    }

    private Inventory createInventory(Player player) {
        InventoryType inventoryType = this.provider.getInventoryType();
        String title = this.provider.getTitle();
        Inventory bukkit = inventoryType != InventoryType.CHEST ? Bukkit.createInventory((InventoryHolder)player, (InventoryType)inventoryType, (String)title) : Bukkit.createInventory((InventoryHolder)player, (int)this.provider.getSize(), (String)title);
        this.inventoryByPlayersMap.put(player, bukkit);
        return bukkit;
    }

    public final void openGui(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        Inventory bukkit = this.createInventory(player);
        this.plugin.getMineLibrary().getGuiManager().getListener().addPlayerGui(player, this);
        this.updateGui0(player, bukkit);
        this.provider.onOpen(player, bukkit);
    }

    public final void updateGui(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        Inventory bukkit = this.getBukkitGui(player);
        if (bukkit != null) {
            this.updateGui0(player, bukkit);
        }
    }

    public void onClose(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        Inventory bukkit = this.inventoryByPlayersMap.remove(player);
        this.sessionByPlayersMap.remove(player);
        this.provider.onClosed(player, bukkit);
    }

    public void onClick(@NonNull Player player, @NonNull MLInventoryClickEvent event) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        GuiProvider.DrawingSession drawingSession = this.sessionByPlayersMap.get(player);
        if (drawingSession != null) {
            GuiItem item = drawingSession.getItem(event.getSlot());
            if (item == null) {
                event.setCancelled(true);
                return;
            }
            item.getClickActionConsumer().accept(event);
        }
    }

    Gui(MinecraftPlugin plugin, GuiProvider provider) {
        this.plugin = plugin;
        this.provider = provider;
    }
}

