/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.cooldown;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import net.pxstudios.minelib.cooldown.Cooldown;
import net.pxstudios.minelib.cooldown.CooldownFlag;
import net.pxstudios.minelib.cooldown.CooldownLeftReason;
import net.pxstudios.minelib.event.player.MLPlayerCooldownAddEvent;
import net.pxstudios.minelib.event.player.MLPlayerCooldownLeftEvent;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerQuitEvent;

public final class PlayerCooldownApi {
    public static final long DEFAULT_RETURN_VALUE = -1L;
    static final Multimap<Player, Cooldown> cooldownsMultimap = HashMultimap.create();
    private final MinecraftPlugin plugin;

    public PlayerCooldownApi(MinecraftPlugin plugin) {
        this.plugin = plugin;
        plugin.getMineLibrary().getEventsSubscriber().subscribe(PlayerQuitEvent.class, EventPriority.HIGHEST).complete(event -> {
            for (Cooldown cooldown : new HashSet(cooldownsMultimap.get((Object)event.getPlayer()))) {
                if (!cooldown.hasFlag(CooldownFlag.REMOVE_ON_PLAYER_QUIT)) continue;
                cooldown.left(CooldownLeftReason.PLAYER_QUIT);
                if (cooldown.getPlayer() == null) continue;
                this.callCooldownLeftEvent(cooldown.getPlayer(), cooldown, CooldownLeftReason.PLAYER_QUIT);
            }
        });
    }

    private void cleanUp(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        new HashSet(cooldownsMultimap.get((Object)player)).forEach(cooldown -> {
            if (cooldown.isExpired()) {
                cooldown.left(CooldownLeftReason.TIME_EXPIRED);
                this.callCooldownLeftEvent(player, (Cooldown)cooldown, CooldownLeftReason.TIME_EXPIRED);
            }
        });
    }

    private CompletableFuture<CooldownLeftReason> addCooldown0(@NonNull Player player, @NonNull Cooldown cooldown) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (cooldown == null) {
            throw new NullPointerException("cooldown is marked non-null but is null");
        }
        this.cleanUp(player);
        CompletableFuture<CooldownLeftReason> completableFuture = new CompletableFuture<CooldownLeftReason>();
        cooldown.setOnLeft(completableFuture);
        cooldown.setPlayer(player);
        if (cooldown.hasFlag(CooldownFlag.WITH_AUTO_EXPIRATION)) {
            cooldown.enableAutoExpirationTask(this.plugin);
        }
        cooldownsMultimap.put((Object)player, (Object)cooldown);
        this.callCooldownAddEvent(player, cooldown);
        return completableFuture;
    }

    public CompletableFuture<CooldownLeftReason> addCooldown(Player player, Cooldown cooldown) {
        return this.addCooldown0(player, cooldown);
    }

    public CompletableFuture<CooldownLeftReason> addCooldown(Player player, @NonNull String name, long millisecondsDelay) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.addCooldown(player, Cooldown.byMilliseconds(name, millisecondsDelay));
    }

    public long getCachedDelay(@NonNull Player player, @NonNull String name) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.cleanUp(player);
        for (Cooldown cooldown : cooldownsMultimap.get((Object)player)) {
            if (!cooldown.getName().equals(name)) continue;
            return cooldown.getMillisecondsDelay();
        }
        return -1L;
    }

    public long getLeftTime(@NonNull Player player, @NonNull String name) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.cleanUp(player);
        for (Cooldown cooldown : cooldownsMultimap.get((Object)player)) {
            if (!cooldown.getName().equals(name)) continue;
            return cooldown.getMillisecondsDelay() - (System.currentTimeMillis() - cooldown.getInitMillisecondsTime());
        }
        return -1L;
    }

    public boolean hasCooldown(@NonNull Player player, @NonNull String name) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getLeftTime(player, name) > 0L;
    }

    private void callCooldownAddEvent(Player player, Cooldown cooldown) {
        this.plugin.getMineLibrary().getEventsSubscriber().callEvent(new MLPlayerCooldownAddEvent(this.plugin.getMineLibrary(), player, cooldown.getName(), cooldown.getMillisecondsDelay()));
    }

    private void callCooldownLeftEvent(Player player, Cooldown cooldown, CooldownLeftReason reason) {
        this.plugin.getMineLibrary().getEventsSubscriber().callEvent(new MLPlayerCooldownLeftEvent(this.plugin.getMineLibrary(), player, cooldown.getName(), cooldown.getMillisecondsDelay(), reason));
    }
}

