/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.common.location;

import net.pxstudios.minelib.common.location.point.Point2D;
import net.pxstudios.minelib.common.location.point.Point3D;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;

public class BukkitLocationBuilder {
    private final Server server;
    private World world;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;

    public BukkitLocationBuilder world(World world) {
        this.world = world;
        return this;
    }

    public BukkitLocationBuilder world(String worldName) {
        return this.world(this.server.getWorld(worldName));
    }

    public BukkitLocationBuilder world(int worldIndex) {
        return this.world((World)this.server.getWorlds().get(worldIndex));
    }

    public BukkitLocationBuilder worldMain() {
        return this.world(0);
    }

    public BukkitLocationBuilder x(double x) {
        this.x = x;
        return this;
    }

    public BukkitLocationBuilder y(double y) {
        this.y = y;
        return this;
    }

    public BukkitLocationBuilder z(double z) {
        this.z = z;
        return this;
    }

    public BukkitLocationBuilder yaw(float yaw) {
        this.yaw = yaw;
        return this;
    }

    public BukkitLocationBuilder pitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public Location build() {
        return new Location(this.world, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public Point2D build2D() {
        return new Point2D(this.x, this.y);
    }

    public Point3D build3D() {
        return new Point3D(this.x, this.y, this.z);
    }

    BukkitLocationBuilder(Server server) {
        this.server = server;
    }
}

