/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.common.item;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.pxstudios.minelib.common.item.BukkitItem;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.core.util.ReflectionUtil;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

public final class BukkitItemModifySession {
    private final BukkitItem bukkitItem;
    private final ItemStack itemStack;
    private BiFunction<Player, BukkitItemModifySession, BukkitItem> customItemModifier;

    public BukkitItemModifySession withCustomModifications(BiFunction<Player, BukkitItemModifySession, BukkitItem> customItemModifier) {
        this.customItemModifier = customItemModifier;
        return this;
    }

    public BukkitItemModifySession withType(Material material) {
        this.itemStack.setType(material);
        return this;
    }

    public BukkitItemModifySession withTypeName(String typeName) {
        return this.withType(Material.matchMaterial((String)typeName));
    }

    public BukkitItemModifySession withTypeId(int typeID) {
        return this.withType(Material.getMaterial((int)typeID));
    }

    public BukkitItemModifySession withDurability(short durability) {
        this.itemStack.setDurability(durability);
        return this;
    }

    public BukkitItemModifySession withDurabilityAsInt(int durability) {
        return this.withDurability((byte)durability);
    }

    public BukkitItemModifySession withAmount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    public BukkitItemModifySession withData(MaterialData materialData) {
        this.itemStack.setData(materialData);
        return this;
    }

    private <Meta extends ItemMeta> void modifyMeta(Consumer<Meta> metaConsumer) {
        if (metaConsumer == null) {
            return;
        }
        ItemMeta meta = this.itemStack.getItemMeta();
        metaConsumer.accept(meta);
        this.itemStack.setItemMeta(meta);
    }

    public BukkitItemModifySession withName(String name) {
        this.modifyMeta(itemMeta -> itemMeta.setDisplayName(name));
        return this;
    }

    public BukkitItemModifySession withColoredName(char altColorChar, String name) {
        return this.withName(ChatColor.translateAlternateColorCodes((char)altColorChar, (String)name));
    }

    public BukkitItemModifySession withColoredName(String name) {
        return this.withColoredName('&', name);
    }

    public BukkitItemModifySession withLoreList(List<String> loreList) {
        this.modifyMeta(itemMeta -> itemMeta.setLore(loreList));
        return this;
    }

    public BukkitItemModifySession withColoredLoreList(char altColorChar, List<String> loreList) {
        ArrayList<String> loreClone = new ArrayList<String>(loreList);
        loreClone.replaceAll(line -> ChatColor.translateAlternateColorCodes((char)altColorChar, (String)line));
        return this.withLoreList(loreClone);
    }

    public BukkitItemModifySession withColoredLoreList(List<String> loreList) {
        return this.withColoredLoreList('&', loreList);
    }

    public BukkitItemModifySession withLoreArray(String ... loreArray) {
        return this.withLoreList(Arrays.asList(loreArray));
    }

    public BukkitItemModifySession withColoredLoreArray(char altColorChar, String ... loreArray) {
        return this.withColoredLoreList(altColorChar, Arrays.asList(loreArray));
    }

    public BukkitItemModifySession withColoredLoreArray(String ... loreArray) {
        return this.withColoredLoreList(Arrays.asList(loreArray));
    }

    public BukkitItemModifySession withUnbreakable(boolean flag) {
        this.modifyMeta(itemMeta -> itemMeta.setUnbreakable(flag));
        return this;
    }

    public BukkitItemModifySession withUnbreakable() {
        return this.withUnbreakable(true);
    }

    public BukkitItemModifySession withFlag(ItemFlag itemFlag) {
        this.modifyMeta(itemMeta -> itemMeta.addItemFlags(new ItemFlag[]{itemFlag}));
        return this;
    }

    public BukkitItemModifySession withFlagsArray(ItemFlag ... itemFlagsArray) {
        this.modifyMeta(itemMeta -> itemMeta.addItemFlags(itemFlagsArray));
        return this;
    }

    public BukkitItemModifySession withAllFlags() {
        return this.withFlagsArray(ItemFlag.values());
    }

    public BukkitItemModifySession withEnchant(Enchantment enchantment, int level, boolean flag) {
        this.modifyMeta(itemMeta -> itemMeta.addEnchant(enchantment, level, flag));
        return this;
    }

    public BukkitItemModifySession withEnchant(Enchantment enchantment, boolean flag) {
        return this.withEnchant(enchantment, 1, flag);
    }

    public BukkitItemModifySession withEnchant(Enchantment enchantment, int level) {
        return this.withEnchant(enchantment, level, true);
    }

    public BukkitItemModifySession withEnchant(Enchantment enchantment) {
        return this.withEnchant(enchantment, 1);
    }

    public BukkitItemModifySession withSkullOwner(String skullOwner) {
        this.modifyMeta(itemMeta -> itemMeta.setOwner(skullOwner));
        return this;
    }

    public BukkitItemModifySession withGameProfile(GameProfile gameProfile) {
        this.modifyMeta(itemMeta -> {
            try {
                ReflectionUtil.setFieldValue((Field)gameProfile.getClass().getDeclaredField("profile"), (Object)itemMeta, (Object)gameProfile);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
        return this;
    }

    public BukkitItemModifySession withTextureAndSignature(String value, String signature) {
        Object uuidString = value;
        if (signature != null) {
            uuidString = value + signature;
        }
        GameProfile gameProfile = new GameProfile(UUID.nameUUIDFromBytes(((String)uuidString).getBytes()), null);
        if (signature != null) {
            if (value != null) {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", value, signature));
            } else {
                String texture = "http://textures.minecraft.net/texture/" + signature;
                byte[] encodedData = Base64.encodeBase64((byte[])String.format("{textures:{SKIN:{url:\"%s\"}}}", texture).getBytes());
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(encodedData)));
            }
        } else {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", value));
        }
        return this.withGameProfile(gameProfile);
    }

    public BukkitItemModifySession withTextureValue(String value) {
        return this.withTextureAndSignature(value, null);
    }

    public BukkitItemModifySession withTextureSignature(String signature) {
        return this.withTextureAndSignature(null, signature);
    }

    public BukkitItemModifySession withLeatherColor(Color color) {
        this.modifyMeta(itemMeta -> itemMeta.setColor(color));
        return this;
    }

    public BukkitItemModifySession withLeatherColorMixed(Color mainColor, Color ... mixedColors) {
        this.modifyMeta(itemMeta -> itemMeta.setColor(mainColor.mixColors(mixedColors)));
        return this;
    }

    public BukkitItemModifySession withLeatherDyeColorMixed(Color mainColor, DyeColor ... mixedColors) {
        this.modifyMeta(itemMeta -> itemMeta.setColor(mainColor.mixDyes(mixedColors)));
        return this;
    }

    public BukkitItemModifySession withLeatherRGB(int red, int green, int blue) {
        return this.withLeatherColor(Color.fromRGB((int)red, (int)green, (int)blue));
    }

    public BukkitItemModifySession withLeatherRGB(int rgb) {
        return this.withLeatherColor(Color.fromRGB((int)rgb));
    }

    public BukkitItem complete() {
        return this.bukkitItem;
    }

    BukkitItemModifySession(BukkitItem bukkitItem, ItemStack itemStack) {
        this.bukkitItem = bukkitItem;
        this.itemStack = itemStack;
    }

    public BiFunction<Player, BukkitItemModifySession, BukkitItem> getCustomItemModifier() {
        return this.customItemModifier;
    }
}

