/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.common.item;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.pxstudios.minelib.common.item.BukkitItem;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

public final class BukkitItemFactory {
    public BukkitItem getByStack(ItemStack itemStack) {
        return new BukkitItem(itemStack);
    }

    public BukkitItem getByTypeAndData(Material material, int durability) {
        return new BukkitItem(new ItemStack(material, 1, (short)((byte)durability)));
    }

    public BukkitItem getByType(Material material) {
        return this.getByTypeAndData(material, 0);
    }

    public BukkitItem getByDataAndAmount(MaterialData materialData, int amount) {
        return new BukkitItem(materialData.toItemStack(amount));
    }

    public BukkitItem getByData(MaterialData materialData) {
        return this.getByDataAndAmount(materialData, 1);
    }

    public <Meta extends ItemMeta> BukkitItem getByStackAndMeta(ItemStack itemStack, Consumer<Meta> metaHandler) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        metaHandler.accept(itemMeta);
        itemStack.setItemMeta(itemMeta);
        return this.getByStack(itemStack);
    }

    public BukkitItem getByStackAndName(ItemStack itemStack, String name) {
        return this.getByStackAndMeta(itemStack, itemMeta -> itemMeta.setDisplayName(name));
    }

    public BukkitItem getByStackAndLoreList(ItemStack itemStack, List<String> loreList) {
        return this.getByStackAndMeta(itemStack, itemMeta -> itemMeta.setLore(loreList));
    }

    public BukkitItem getByStackAndLoreArray(ItemStack itemStack, String ... loreArray) {
        return this.getByStackAndLoreList(itemStack, Arrays.asList(loreArray));
    }

    BukkitItemFactory() {
    }
}

