/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.common.config.provider;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.pxstudios.minelib.common.config.PluginConfigProvider;
import net.pxstudios.minelib.common.config.type.YamlPluginConfig;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlConfigProvider
implements PluginConfigProvider<YamlConfiguration> {
    private final Map<File, YamlConfiguration> typesByFileMap = new HashMap<File, YamlConfiguration>();

    @Override
    public boolean validateFileFormat(File file) {
        return file.getName().endsWith(".yml") || file.getName().endsWith(".yaml");
    }

    @Override
    public YamlConfiguration provide(File file) {
        YamlConfiguration configuration = this.typesByFileMap.get(file);
        if (configuration == null) {
            configuration = YamlConfiguration.loadConfiguration((File)file);
            this.typesByFileMap.put(file, configuration);
        }
        return configuration;
    }

    public YamlPluginConfig createConfig(File file) {
        return new YamlPluginConfig(this, file);
    }

    @Override
    public void save(File file, YamlConfiguration configuration) {
        configuration.save(file);
    }

    @Override
    public void cleanUp(File file) {
        this.typesByFileMap.remove(file);
    }
}

