/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.common.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.pxstudios.minelib.common.config.PluginConfig;
import net.pxstudios.minelib.common.config.PluginConfigProvider;
import net.pxstudios.minelib.common.config.provider.PropertiesConfigProvider;
import net.pxstudios.minelib.common.config.provider.TextConfigProvider;
import net.pxstudios.minelib.common.config.provider.YamlConfigProvider;
import net.pxstudios.minelib.common.config.type.PropertiesPluginConfig;
import net.pxstudios.minelib.common.config.type.TextPluginConfig;
import net.pxstudios.minelib.common.config.type.YamlPluginConfig;

public final class PluginConfigManager {
    private final Map<Class<?>, PluginConfigProvider<?>> providersByTypeMap = new HashMap();

    public void addProvider(PluginConfigProvider<?> provider) {
        this.providersByTypeMap.put(provider.getClass(), provider);
    }

    public void addDefaultProviders() {
        this.addProvider(new PropertiesConfigProvider());
        this.addProvider(new TextConfigProvider());
        this.addProvider(new YamlConfigProvider());
    }

    public <Type> PluginConfigProvider<Type> getProvider(Class<? extends PluginConfigProvider<Type>> cls) {
        return this.providersByTypeMap.get(cls);
    }

    public <Type> PluginConfig<Type> createConfigObject(Class<? extends PluginConfigProvider<Type>> cls, File file) {
        PluginConfigProvider<Type> provider = this.getProvider(cls);
        if (provider != null) {
            if (!provider.validateFileFormat(file)) {
                throw new IllegalArgumentException(String.format("Invalid `%s` format", file.getName()));
            }
            return provider.createConfig(file);
        }
        return null;
    }

    public PropertiesPluginConfig createPropertiesConfig(File file) {
        return (PropertiesPluginConfig)this.createConfigObject(PropertiesConfigProvider.class, file);
    }

    public TextPluginConfig createTextConfig(File file) {
        return (TextPluginConfig)this.createConfigObject(TextConfigProvider.class, file);
    }

    public YamlPluginConfig createYamlConfig(File file) {
        return (YamlPluginConfig)this.createConfigObject(YamlConfigProvider.class, file);
    }
}

