/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.common.complex;

import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.material.MaterialData;

public abstract class ComplexBlockAdapter {
    private static final BlockFace[] FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.SELF};
    private final Location[] locations = new Location[2];

    public ComplexBlockAdapter(Material material, Location location, Function<MaterialData, Boolean> headDetectFunction) {
        if (headDetectFunction == null) {
            headDetectFunction = data -> this.locations[0] == null;
        }
        for (BlockFace face : FACES) {
            Block relative = location.getBlock().getRelative(face);
            if (relative.getType() != material) continue;
            this.locations[headDetectFunction.apply((MaterialData)relative.getState().getData()).booleanValue() ? 0 : 1] = relative.getLocation();
        }
    }

    public Location getHeadPart() {
        return this.locations[0];
    }

    public Location getBodyPart() {
        return this.locations[1];
    }

    public boolean contains(Location location) {
        for (Location part : this.getLocations()) {
            if (!location.equals((Object)part)) continue;
            return true;
        }
        return false;
    }

    public Location[] getLocations() {
        return this.locations;
    }
}

