/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.command.type;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.pxstudios.minelib.command.CommandContext;
import net.pxstudios.minelib.command.CommandSettings;

public abstract class AbstractContextCommand {
    private final Set<String> activeLabels = new HashSet<String>();
    private final Set<CommandSettings<?>> settings = new HashSet();

    public void addLabels(String ... labels) {
        this.activeLabels.addAll(Arrays.stream(labels).map(String::toLowerCase).collect(Collectors.toSet()));
    }

    public void addSetting(CommandSettings<?> commandSetting) {
        this.settings.add(commandSetting);
    }

    public <R> void addSetting(CommandSettings<R> commandSetting, R value) {
        this.settings.add(commandSetting.set(value));
    }

    public <T> T getSettingValue(CommandSettings<T> commandSetting) {
        for (CommandSettings<?> commandSettings : this.getSettings()) {
            if (!commandSettings.getName().equals(commandSetting.getName())) continue;
            return commandSetting.value();
        }
        return null;
    }

    public abstract void process(CommandContext var1);

    public Set<String> getActiveLabels() {
        return this.activeLabels;
    }

    public Set<CommandSettings<?>> getSettings() {
        return this.settings;
    }
}

