/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.command;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.pxstudios.minelib.command.CommandSettings;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandContext {
    private final Set<CommandSettings<?>> settings;
    private final CommandSender commandSender;
    private final String[] arguments;
    private final String label;

    public <R> CommandSettings<R> getSetting(String name) {
        for (CommandSettings<?> commandSettings : this.settings) {
            if (!commandSettings.getName().equals(name)) continue;
            return commandSettings;
        }
        return null;
    }

    public void withArgumentsOrFail(int requireSize, Runnable process, Runnable onFail) {
        if (this.arguments.length < requireSize) {
            onFail.run();
            return;
        }
        process.run();
    }

    public void withArguments(int requireSize, Runnable process) {
        this.withArgumentsOrFail(requireSize, process, () -> {
            CommandSettings message = this.getSetting("EMPTY_ARGS_MESSAGE");
            this.commandSender.sendMessage((String)message.value());
        });
    }

    public int argumentsSize() {
        return this.arguments.length;
    }

    public Argument argument(int index) {
        return new Argument(index - 1);
    }

    public <T> Optional<T> argument(int index, Function<String, T> parser) {
        return this.argument(index).as(parser);
    }

    public String argumentStr(int index) {
        return this.argument(index).toString();
    }

    public CommandSender sender() {
        return this.commandSender;
    }

    public Player senderAsPlayer() {
        return (Player)this.commandSender;
    }

    public CommandContext(Set<CommandSettings<?>> settings, CommandSender commandSender, String[] arguments, String label) {
        this.settings = settings;
        this.commandSender = commandSender;
        this.arguments = arguments;
        this.label = label;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getLabel() {
        return this.label;
    }

    public class Argument {
        private final int index;

        public String toString() {
            return CommandContext.this.arguments[this.index];
        }

        public <T> T asOrFail(Function<String, T> parseFunction, Supplier<T> onFail) {
            if (onFail == null) {
                onFail = () -> {
                    CommandContext.this.commandSender.sendMessage(ChatColor.RED + String.format("Unknown argument (%d) assertion type!", this.index));
                    return null;
                };
            }
            try {
                T value = parseFunction.apply(this.toString());
                if (value == null) {
                    return (T)onFail.get();
                }
                return value;
            }
            catch (Throwable throwable) {
                return (T)onFail.get();
            }
        }

        public <T> Optional<T> asOrFail(Function<String, T> parseFunction, Runnable onFail) {
            return Optional.ofNullable(this.asOrFail(parseFunction, () -> {
                if (onFail != null) {
                    onFail.run();
                }
                return null;
            }));
        }

        public <T> Optional<T> as(Function<String, T> parseFunction) {
            return this.asOrFail(parseFunction, (Runnable)null);
        }

        public Optional<Player> asOnlinePlayerOrFail(Runnable onFail) {
            return this.asOrFail(Bukkit::getPlayer, onFail);
        }

        public Optional<Player> asOnlinePlayer() {
            return this.asOnlinePlayerOrFail(null);
        }

        public Optional<OfflinePlayer> asOfflinePlayerOrFail(Runnable onFail) {
            return this.asOrFail(Bukkit::getOfflinePlayer, onFail);
        }

        public Optional<OfflinePlayer> asOfflinePlayer() {
            return this.asOfflinePlayerOrFail(null);
        }

        public Optional<UUID> asUUID(Runnable onFail) {
            return this.asOrFail(UUID::fromString, onFail);
        }

        public Optional<UUID> asUUID() {
            return this.asUUID(null);
        }

        public Optional<UUID> asBytesUUID(Runnable onFail) {
            return this.asOrFail((String str) -> UUID.nameUUIDFromBytes(str.getBytes()), onFail);
        }

        public Optional<UUID> asBytesUUID() {
            return this.asBytesUUID(null);
        }

        public Optional<Integer> asIntOrFail(Runnable onFail) {
            return this.asOrFail(Integer::parseInt, onFail);
        }

        public Optional<Integer> asInt() {
            return this.asIntOrFail(null);
        }

        public Optional<Long> asLongOrFail(Runnable onFail) {
            return this.asOrFail(Long::parseLong, onFail);
        }

        public Optional<Long> asLong() {
            return this.asLongOrFail(null);
        }

        public Optional<Double> asDoubleOrFail(Runnable onFail) {
            return this.asOrFail(Double::parseDouble, onFail);
        }

        public Optional<Double> asDouble() {
            return this.asDoubleOrFail(null);
        }

        public Optional<String> asStringOrFail(Runnable onFail) {
            return this.asOrFail((String s) -> s, onFail);
        }

        public Optional<String> asString() {
            return this.asStringOrFail(null);
        }

        public Argument(int index) {
            this.index = index;
        }
    }
}

