/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.command;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.pxstudios.minelib.command.CommandContext;
import net.pxstudios.minelib.command.CommandSettings;
import net.pxstudios.minelib.command.type.AbstractContextCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

public class BukkitCommandExecuteWrapper
extends Command
implements CommandExecutor {
    private static final String DEF_DESCRIPTION = "Command created & registered by MineLib";
    private final AbstractContextCommand handle;
    private Cache<CommandSender, Long> cooldownDelayCache;
    private long lastCooldownDelayMillisValue;

    protected BukkitCommandExecuteWrapper(AbstractContextCommand handle, String name, String[] aliases) {
        super(name, DEF_DESCRIPTION, "", Arrays.asList(aliases));
        this.handle = handle;
    }

    public boolean execute(CommandSender commandSender, String label, String[] args) {
        if (this.applySettings(commandSender, args)) {
            this.handle.process(new CommandContext(this.handle.getSettings(), commandSender, args, label));
        }
        return false;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String label, String[] args) {
        return this.execute(commandSender, label, args);
    }

    private Cache<CommandSender, Long> injectCooldownDelayCache(long cooldownDelayMillis) {
        if (this.cooldownDelayCache == null) {
            this.lastCooldownDelayMillisValue = cooldownDelayMillis;
            this.cooldownDelayCache = CacheBuilder.newBuilder().expireAfterAccess(this.lastCooldownDelayMillisValue, TimeUnit.MILLISECONDS).build();
        } else if (this.lastCooldownDelayMillisValue != cooldownDelayMillis) {
            this.cooldownDelayCache = null;
            return this.injectCooldownDelayCache(cooldownDelayMillis);
        }
        return this.cooldownDelayCache;
    }

    private boolean applySettings(CommandSender commandSender, String[] args) {
        String permission;
        String message;
        Set<CommandSettings<?>> settings = this.handle.getSettings();
        boolean resultFlag = true;
        if (settings.contains(CommandSettings.SENDER_TYPE)) {
            Class<? extends CommandSender> value = this.handle.getSettingValue(CommandSettings.SENDER_TYPE);
            resultFlag = commandSender.getClass().isAssignableFrom(value);
            if (!resultFlag && settings.contains(CommandSettings.CONSOLE_DISABLED_MESSAGE) && value.isAssignableFrom(ConsoleCommandSender.class)) {
                message = this.handle.getSettingValue(CommandSettings.CONSOLE_DISABLED_MESSAGE);
                commandSender.sendMessage(message);
            }
        }
        if (resultFlag && settings.contains(CommandSettings.EMPTY_ARGS_MESSAGE) && args.length == 0) {
            String message2 = this.handle.getSettingValue(CommandSettings.EMPTY_ARGS_MESSAGE);
            commandSender.sendMessage(message2);
        }
        if (resultFlag && settings.contains(CommandSettings.USE_PERMISSION) && !(resultFlag = commandSender.hasPermission(permission = this.handle.getSettingValue(CommandSettings.USE_PERMISSION))) && settings.contains(CommandSettings.NO_PERMISSION_MESSAGE)) {
            message = this.handle.getSettingValue(CommandSettings.NO_PERMISSION_MESSAGE);
            commandSender.sendMessage(String.format(message, permission));
        }
        if (resultFlag && settings.contains(CommandSettings.USE_COOLDOWN_DELAY)) {
            long cooldownDelayMillis = this.handle.getSettingValue(CommandSettings.USE_COOLDOWN_DELAY);
            Cache<CommandSender, Long> cooldownDelayCache = this.injectCooldownDelayCache(cooldownDelayMillis);
            cooldownDelayCache.cleanUp();
            boolean bl = resultFlag = !cooldownDelayCache.asMap().containsKey(commandSender);
            if (resultFlag) {
                cooldownDelayCache.put((Object)commandSender, (Object)System.currentTimeMillis());
            } else if (settings.contains(CommandSettings.HAS_COOLDOWN_DELAY_MESSAGE)) {
                long cooldownLeftMillis = cooldownDelayMillis - (System.currentTimeMillis() - (Long)cooldownDelayCache.asMap().get(commandSender));
                long cooldownLeftSeconds = TimeUnit.MILLISECONDS.toSeconds(cooldownLeftMillis);
                if (cooldownLeftMillis > 0L) {
                    String message3 = this.handle.getSettingValue(CommandSettings.HAS_COOLDOWN_DELAY_MESSAGE);
                    commandSender.sendMessage(String.format(message3, cooldownLeftSeconds));
                } else {
                    resultFlag = true;
                }
            }
        }
        return resultFlag;
    }

    AbstractContextCommand getHandle() {
        return this.handle;
    }
}

