/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.board;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public final class BoardPresetsManager {
    private final Map<String, Supplier<String>> map = new HashMap<String, Supplier<String>>();

    public void add(String key, Supplier<String> presetSupplier) {
        this.map.put(key.toLowerCase(), presetSupplier);
    }

    public void add(String key, String preset) {
        this.add(key.toLowerCase(), () -> preset);
    }

    public void delete(String key) {
        this.map.remove(key.toLowerCase());
    }

    public Supplier<String> getAsSupplier(String key) {
        return this.map.getOrDefault(key.toLowerCase(), () -> null);
    }

    public String getAsString(String key) {
        return this.getAsSupplier(key).get();
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public void addAll(BoardPresetsManager presetsManager) {
        this.map.putAll(presetsManager.map);
    }

    public void removeAll() {
        this.map.clear();
    }

    BoardPresetsManager() {
    }
}

