/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.board;

import gnu.trove.TCollections;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.function.Function;
import net.pxstudios.minelib.board.Board;
import net.pxstudios.minelib.board.BoardField;
import net.pxstudios.minelib.board.BoardFlag;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;

public class BoardObjective {
    private final Board board;
    private final TIntObjectMap<BoardField> fieldsMap = TCollections.synchronizedMap((TIntObjectMap)new TIntObjectHashMap());
    private final DisplaySlot display;
    private final String name;
    private final String criteria;
    private String displayName;

    public final TIntObjectMap<BoardField> getScores() {
        return TCollections.unmodifiableMap(this.fieldsMap);
    }

    private BoardField createField0(int position) {
        return new BoardField(this.board, position);
    }

    public final BoardField createStaticField(int position, String text) {
        if (this.board.hasFlag(BoardFlag.WITH_AUTOMATICALLY_STATIC_LINES_COLORIZE)) {
            text = ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        }
        return this.createField0(position).setStaticText(text);
    }

    public final BoardField createModifiableField(int position, Function<Player, String> textGetter) {
        return this.createField0(position).setModifiableText(textGetter);
    }

    public final void setField(BoardField field) {
        if (field == null) {
            throw new NullPointerException("score");
        }
        if (this.fieldsMap.put(field.getPosition(), (Object)field) == null) {
            for (Player player : this.board.getPlayersViews()) {
                field.sendAction(player, BoardField.Action.CREATE);
            }
        } else {
            for (Player player : this.board.getPlayersViews()) {
                field.sendAction(player, BoardField.Action.UPDATE);
            }
        }
    }

    public void setStaticField(int position, String text) {
        BoardField field = this.createStaticField(position, text);
        this.setField(field);
    }

    public void setModifiableField(int position, Function<Player, String> textGetter) {
        BoardField field = this.createModifiableField(position, textGetter);
        this.setField(field);
    }

    public final void removeField(int position) {
        BoardField field = (BoardField)this.fieldsMap.remove(position);
        if (field == null) {
            throw new IllegalArgumentException("score position (" + position + ")");
        }
        for (Player player : this.board.getPlayersViews()) {
            field.sendAction(player, BoardField.Action.REMOVE);
        }
    }

    public final BoardField getField(int position) {
        return (BoardField)this.fieldsMap.get(position);
    }

    private void sendFieldsAction(Player player, BoardField.Action action) {
        this.fieldsMap.forEachValue(boardField -> {
            boardField.sendAction(player, action);
            return true;
        });
    }

    void sendUpdateStatus(Player player) {
        this.sendFieldsAction(player, BoardField.Action.UPDATE);
    }

    void sendCreateStatus(Player player) {
        this.sendFieldsAction(player, BoardField.Action.CREATE);
    }

    void sendRemoveStatus(Player player) {
        this.sendFieldsAction(player, BoardField.Action.REMOVE);
    }

    public BoardObjective(Board board, DisplaySlot display, String name, String criteria) {
        this.board = board;
        this.display = display;
        this.name = name;
        this.criteria = criteria;
    }

    public DisplaySlot getDisplay() {
        return this.display;
    }

    public String getName() {
        return this.name;
    }

    public String getCriteria() {
        return this.criteria;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

