/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.board;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.pxstudios.minelib.board.BoardApi;
import net.pxstudios.minelib.board.BoardFlag;
import net.pxstudios.minelib.board.BoardObjective;
import net.pxstudios.minelib.board.BoardPresetsManager;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import net.pxstudios.minelib.subscription.EventsSubscriber;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.DisplaySlot;

public class Board {
    private static final String UNKNOWN_PRESET_FORMAT = "PRESET(%s)";
    private static final String SMART_PRESET_LINE_PREFIX = "preset:";
    private final BoardApi boardApi;
    private final MinecraftPlugin plugin;
    private final BoardObjective objective;
    private final Set<Player> playersViewSet = new HashSet<Player>();
    private final Set<BoardFlag> flagsSet = new HashSet<BoardFlag>();
    private final Set<String> disabledWorldsSet = new HashSet<String>();
    private final BoardPresetsManager localPresetsManager;

    public Board(BoardApi boardApi, DisplaySlot display, String name, String criteria) {
        this.boardApi = boardApi;
        this.plugin = boardApi.getPlugin();
        this.objective = boardApi.createObjective(this, display, name, criteria);
        this.localPresetsManager = boardApi.createPresetsManager();
    }

    public Board(BoardApi boardApi, String name, String criteria) {
        this(boardApi, DisplaySlot.SIDEBAR, name, criteria);
    }

    public Board(BoardApi boardApi, String name) {
        this(boardApi, DisplaySlot.SIDEBAR, name, "dummy");
    }

    public Board(BoardApi boardApi, DisplaySlot display, String name) {
        this(boardApi, display, name, "dummy");
    }

    private BoardPresetsManager joinAllPresets() {
        BoardPresetsManager presetsManager = this.boardApi.createPresetsManager();
        presetsManager.addAll(this.localPresetsManager);
        if (this.hasFlag(BoardFlag.USE_GLOBAL_PRESETS)) {
            presetsManager.addAll(this.boardApi.getGlobalPresetsManager());
        }
        return presetsManager;
    }

    public final void subscribePlayerEvents(EventsSubscriber eventsSubscriber) {
        eventsSubscriber.subscribe(PlayerJoinEvent.class, EventPriority.HIGHEST).complete(event -> {
            if (this.hasFlag(BoardFlag.VIEW_ON_PLAYER_JOIN)) {
                this.addPlayerView(event.getPlayer());
            }
        });
        eventsSubscriber.subscribe(PlayerQuitEvent.class, EventPriority.HIGHEST).complete(event -> {
            Player player = event.getPlayer();
            if (this.isViewing(player) && this.hasFlag(BoardFlag.REMOVE_ON_PLAYER_JOIN)) {
                this.removePlayerView(player);
            }
        });
        eventsSubscriber.subscribe(PlayerChangedWorldEvent.class, EventPriority.HIGHEST).complete(event -> {
            Player player = event.getPlayer();
            if (this.isViewing(player) && this.hasFlag(BoardFlag.USE_DISABLED_WORLD_SYSTEM)) {
                World worldFrom = event.getFrom();
                World worldTo = player.getWorld();
                if (this.isDisabledWorld(worldTo)) {
                    this.sendRemoveStatus(player);
                } else if (this.isDisabledWorld(worldFrom)) {
                    this.sendCreateStatus(player);
                }
            }
        });
    }

    public final boolean addDisabledWorld(String disabledWorldName) {
        return this.disabledWorldsSet.add(disabledWorldName.toLowerCase());
    }

    public final boolean removeDisabledWorld(String disabledWorldName) {
        return this.disabledWorldsSet.remove(disabledWorldName.toLowerCase());
    }

    public final boolean isDisabledWorld(String worldName) {
        return this.disabledWorldsSet.contains(worldName.toLowerCase());
    }

    public final boolean isDisabledWorld(@NonNull World world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        return this.isDisabledWorld(world.getName());
    }

    public final Set<String> getDisabledWorldsNames() {
        return Collections.unmodifiableSet(this.disabledWorldsSet);
    }

    public final Set<World> getDisabledWorlds() {
        return Collections.unmodifiableSet(this.disabledWorldsSet.stream().map(Bukkit::getWorld).collect(Collectors.toSet()));
    }

    public final Board addFlag(@NonNull BoardFlag flag) {
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        this.flagsSet.add(flag);
        return this;
    }

    public final Board removeFlag(@NonNull BoardFlag flag) {
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        this.flagsSet.remove((Object)flag);
        return this;
    }

    public final boolean hasFlag(@NonNull BoardFlag flag) {
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        return this.flagsSet.contains((Object)flag);
    }

    protected final void checkObjectiveNullable() {
        if (this.objective == null) {
            throw new NullPointerException("objective");
        }
    }

    public final boolean isViewing(Player player) {
        return this.playersViewSet.contains(player);
    }

    public final boolean addPlayerView(Player player) {
        boolean add;
        Board previous = this.boardApi.getActiveBoard(player);
        if (previous != null && previous.hasFlag(BoardFlag.REMOVE_ON_CHANGED)) {
            previous.removePlayerView(player);
        }
        if (add = this.playersViewSet.add(player)) {
            this.sendCreateStatus(player);
        }
        return add;
    }

    public final boolean removePlayerView(Player player) {
        boolean remove = this.playersViewSet.remove(player);
        if (remove) {
            this.sendRemoveStatus(player);
        }
        return remove;
    }

    public final boolean update(Player player) {
        boolean contains;
        boolean bl = contains = player != null && this.playersViewSet.contains(player);
        if (contains) {
            this.sendUpdateStatus(player);
        }
        return contains;
    }

    public final Set<Player> getPlayersViews() {
        return Collections.unmodifiableSet(this.playersViewSet);
    }

    void sendUpdateStatus(Player player) {
        this.checkObjectiveNullable();
        this.objective.sendUpdateStatus(player);
    }

    void sendCreateStatus(Player player) {
        this.checkObjectiveNullable();
        this.objective.sendCreateStatus(player);
    }

    void sendRemoveStatus(Player player) {
        this.checkObjectiveNullable();
        this.objective.sendRemoveStatus(player);
    }

    public final void setDisplayName(@NonNull String displayName) {
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        this.checkObjectiveNullable();
        boolean preset = displayName.toLowerCase().startsWith(SMART_PRESET_LINE_PREFIX);
        if (preset) {
            displayName = displayName.substring(SMART_PRESET_LINE_PREFIX.length());
            String presetString = this.joinAllPresets().getAsString(displayName);
            if (presetString == null) {
                displayName = String.format(UNKNOWN_PRESET_FORMAT, displayName);
            }
        }
        this.objective.setDisplayName(displayName);
    }

    private String getBlackLineText(int position) {
        char[] charsArray;
        char selectedChar = charsArray[position >= (charsArray = BoardApi.BLANK_LINE_CHARS_BY_POSITION).length || position < 0 ? 0 : position];
        return ChatColor.getByChar((char)selectedChar).toString();
    }

    public final Board setStaticLine(int position, String text) {
        this.checkObjectiveNullable();
        this.objective.setStaticField(position, text);
        return this;
    }

    public final Board setModifiableLine(int position, Function<Player, String> textGetter) {
        this.checkObjectiveNullable();
        this.objective.setModifiableField(position, textGetter);
        return this;
    }

    public final Board setBlankLine(int position) {
        return this.setStaticLine(position, this.getBlackLineText(position));
    }

    public final Board setPresetLine(int position, String presetKey) {
        String staticText = String.format(UNKNOWN_PRESET_FORMAT, presetKey);
        String presetString = this.joinAllPresets().getAsString(presetKey);
        if (presetString != null) {
            staticText = presetString;
        }
        return this.setStaticLine(position, staticText);
    }

    public final Board setLineSmart(int position) {
        return this.setBlankLine(position);
    }

    public final Board setLineSmart(int position, String text) {
        boolean preset = text.toLowerCase().startsWith(SMART_PRESET_LINE_PREFIX);
        return !preset ? this.setStaticLine(position, text) : this.setPresetLine(position, text.substring(SMART_PRESET_LINE_PREFIX.length()));
    }

    public final Board setLineSmart(int position, Function<Player, String> textGetter) {
        return this.setModifiableLine(position, textGetter);
    }

    public final void update(int ticks, final Supplier<Boolean> actionOnUpdate) {
        this.plugin.getMineLibrary().getBeater().runCancellableTimer(ticks, ticks, new BukkitRunnable(){

            public void run() {
                boolean canTaskContinue = (Boolean)actionOnUpdate.get();
                Board.this.playersViewSet.forEach(player -> {
                    if (player.isOnline()) {
                        Board.this.update((Player)player);
                    }
                });
                if (!canTaskContinue) {
                    this.cancel();
                }
            }
        });
    }

    public final void update(int ticks) {
        this.update(ticks, () -> true);
    }

    public BoardObjective getObjective() {
        return this.objective;
    }

    public BoardPresetsManager getLocalPresetsManager() {
        return this.localPresetsManager;
    }
}

