/*
 * Decompiled with CFR 0.152.
 */
package net.jest.util;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;

public final class CacheUtil {
    public static final Map<Class<?>, Object> classInstanceMap = new LinkedHashMap();

    public static <T> T putIfAbsent(@NonNull Class<T> tClass) {
        if (tClass == null) {
            throw new NullPointerException("tClass is marked non-null but is null");
        }
        try {
            Object t = classInstanceMap.get(tClass);
            if (t == null) {
                t = tClass.newInstance();
                classInstanceMap.put(tClass, t);
            }
            return (T)t;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private CacheUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

