/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.syllabus.http;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;
import works.lmz.common.jackson.JacksonException;
import works.lmz.common.jackson.JacksonHelper;
import works.lmz.syllabus.ResponseCode;
import works.lmz.syllabus.SyllabusContext;
import works.lmz.syllabus.dispatcher.CentralDispatch;
import works.lmz.syllabus.errors.TransmissionException;
import works.lmz.syllabus.hooks.EventHookException;
import works.lmz.syllabus.http.ContentType;
import works.lmz.syllabus.http.HttpSyllabusContext;
import works.lmz.syllabus.http.RequestInformation;

public class SyllabusServlet
extends HttpServlet
implements GroovyObject {
    private static final Logger log;
    @Inject
    private CentralDispatch centralDispatch;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public SyllabusServlet() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void init(ServletConfig config) throws ServletException {
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)((Object)this), (ServletContext)config.getServletContext());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        Object responseObject;
        String contentType;
        this.addCORSHeaders(request, response);
        RequestInformation rInfo = new RequestInformation(request);
        try {
            String string = request.getContentType();
            List list = string != null ? StringGroovyMethods.tokenize((CharSequence)string, (CharSequence)";") : null;
            Object v0 = list != null ? list.get(0) : null;
            String string2 = ShortTypeHandling.castToString(v0);
            contentType = DefaultTypeTransformation.booleanUnbox(v0) ? string2 : ContentType.TEXT_PLAIN;
            log.debug("Incoming content type {}", (Object)contentType);
            HttpSyllabusContext httpSyllabusContext = new HttpSyllabusContext();
            HttpServletRequest httpServletRequest = request;
            httpSyllabusContext.setRequest(httpServletRequest);
            HttpServletResponse httpServletResponse = response;
            httpSyllabusContext.setResponse(httpServletResponse);
            String string3 = rInfo.getAction();
            httpSyllabusContext.setAction(string3);
            String string4 = rInfo.getNamespace();
            httpSyllabusContext.setNamespace(string4);
            String string5 = rInfo.getVersion();
            httpSyllabusContext.setVersion(string5);
            String string6 = IOGroovyMethods.getText((BufferedReader)request.getReader());
            httpSyllabusContext.setRequestBody(string6);
            String string7 = contentType;
            httpSyllabusContext.setContentType(string7);
            HttpSyllabusContext context = httpSyllabusContext;
            responseObject = this.centralDispatch.dispatch((SyllabusContext)context);
            if (responseObject == null) {
                this.writeException(response, ResponseCode.BAD_REQUEST, "{error:'Bad content type or no response from handler'}");
                return;
            }
        }
        catch (TransmissionException transEx) {
            this.writeException(response, transEx.getStatusCode(), transEx.getMessage());
            return;
        }
        catch (EventHookException ehEx) {
            log.info("The execution of this request was stopped because of an exception thrown by a @BeforeEvent event hook", (Throwable)ehEx);
            if (!(ehEx.getStatusCode() > 0)) return;
            this.writeException(response, ehEx.getStatusCode(), ehEx.getMessage());
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            try {
                if (responseObject instanceof String && ScriptBytecodeAdapter.compareEqual((Object)contentType, (Object)ContentType.TEXT_PLAIN)) {
                    response.setHeader("Content-Type", ContentType.TEXT_PLAIN_UTF8);
                    response.getWriter().print(DefaultGroovyMethods.toString((Object)responseObject));
                } else {
                    response.setHeader("Content-Type", ContentType.APPLICATION_JSON_UTF8);
                    response.getWriter().print(JacksonHelper.serialize((Object)responseObject));
                }
                response.getWriter().flush();
                return;
            }
            catch (JacksonException jEx) {
                log.error("Unable to serialize json response message", responseObject);
                this.writeException(response, ResponseCode.BAD_GATEWAY, jEx.getMessage());
                return;
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        this.addCORSHeaders(request, response);
        response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS");
        response.setHeader("Access-Control-Allow-Headers", "X-Request-With, accept, authorization, content-type, origin");
        response.setHeader("Access-Control-Max-Age", "1728000");
    }

    protected void writeException(HttpServletResponse response, int status, String message) {
        response.setStatus(status);
        response.getWriter().write(message);
        response.getWriter().flush();
    }

    protected void addCORSHeaders(HttpServletRequest request, HttpServletResponse response) {
        String string = request.getHeader("Cookie");
        response.setHeader("Access-Control-Allow-Origin", DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "*");
        response.setHeader("Access-Control-Allow-Credentials", "true");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != SyllabusServlet.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger(SyllabusServlet.class);
    }
}

