/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.logging.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import works.lmz.common.jackson.JacksonHelper;
import works.lmz.logging.server.ClientErrorData;
import works.lmz.logging.server.ClientErrorsLogger;
import works.lmz.logging.server.SmartClientErrorsLogger;

public class ClientErrorsHandleServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    static ClientErrorsLogger errorsLogger;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (errorsLogger == null) {
            errorsLogger = new SmartClientErrorsLogger();
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        List lines = IOUtils.readLines((InputStream)req.getInputStream());
        String body = StringUtils.join((Collection)lines, (String)" ");
        try {
            ClientErrorData data = (ClientErrorData)JacksonHelper.deserialize((String)body, ClientErrorData.class);
            errorsLogger.logClientError(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.sendError(500, "Unexpected payload");
        }
    }

    public static void setClientErrorsLogger(ClientErrorsLogger logger) {
        errorsLogger = logger;
    }
}

