/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.syllabus.apidoc.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import works.lmz.syllabus.events.EventHandler;

public class GenericUtils {
    private GenericUtils() {
    }

    public static ParameterizedType getEventHandlerClass(Class<?> leafClass) {
        for (Type interfaceType : leafClass.getGenericInterfaces()) {
            if (!GenericUtils.isEventHandlerInterface(interfaceType)) continue;
            return (ParameterizedType)interfaceType;
        }
        return null;
    }

    public static boolean isEventHandlerInterface(Type interfaceType) {
        return interfaceType instanceof ParameterizedType && ((ParameterizedType)interfaceType).getRawType() == EventHandler.class;
    }

    public static ParameterizedType getFirstParameterizedType(Class<?> leafClass) {
        for (Type interfaceType : leafClass.getGenericInterfaces()) {
            if (!(interfaceType instanceof ParameterizedType)) continue;
            return (ParameterizedType)interfaceType;
        }
        return null;
    }

    public static Class<?> getGenericClassAtIndex(ParameterizedType baseClass, int genericIdx) {
        if (baseClass == null) {
            throw new IllegalArgumentException("Base class cannot be null");
        }
        if (genericIdx < 0) {
            throw new IllegalArgumentException("The generic index cannot be smaller than zero");
        }
        if (baseClass.getActualTypeArguments().length <= genericIdx) {
            throw new IllegalArgumentException("Index cannot be retrieved, type does not have enough");
        }
        Type genInstance = baseClass.getActualTypeArguments()[genericIdx];
        if (genInstance instanceof ParameterizedType) {
            genInstance = ((ParameterizedType)genInstance).getRawType();
        }
        return (Class)genInstance;
    }

    public static Class<?> getGenericClassAtIndexForEvent(Class<?> baseClass, int genericIdx) {
        if (baseClass == null) {
            throw new IllegalArgumentException("Base class cannot be null");
        }
        if (genericIdx < 0) {
            throw new IllegalArgumentException("The generic index cannot be smaller than zero");
        }
        ParameterizedType eventHandlerType = GenericUtils.getEventHandlerClass(baseClass);
        if (eventHandlerType == null) {
            throw new IllegalStateException("Could not find event handler class for this base class, not an EventHandler.");
        }
        if (eventHandlerType.getActualTypeArguments().length <= genericIdx) {
            throw new IllegalArgumentException("Index cannot be retrieved, type does not have enough");
        }
        Type genInstance = eventHandlerType.getActualTypeArguments()[genericIdx];
        if (genInstance instanceof ParameterizedType) {
            genInstance = ((ParameterizedType)genInstance).getRawType();
        }
        return (Class)genInstance;
    }
}

