/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.syllabus.apidoc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Future;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import works.lmz.syllabus.ApiDoc;
import works.lmz.syllabus.apidoc.EndpointDataElement;

public class EndpointData {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointData.class);
    private Class<?> endpointDataClass;
    private List<EndpointDataElement> dataElements;

    public EndpointData(Class<?> endpointDataClass, List<Class<?>> alsoRead) {
        this.endpointDataClass = endpointDataClass;
        this.dataElements = this.initDataElements(alsoRead);
    }

    public List<EndpointDataElement> getDataElements() {
        return this.dataElements;
    }

    public List<EndpointDataElement> initDataElements(List<Class<?>> alsoRead) {
        Method[] methods;
        ArrayList<EndpointDataElement> dataElements = new ArrayList<EndpointDataElement>();
        for (Method method : methods = this.endpointDataClass.getMethods()) {
            if (!method.getName().startsWith("get") || this.bannedMethod(method.getName())) continue;
            dataElements.add(new EndpointDataElement(this.getClassType(method, alsoRead), this.toVariableName(method.getName()), this.getApiDocFor(method), this.getConstraints(method)));
        }
        return dataElements;
    }

    protected String getConstraints(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType.isEnum()) {
            return this.getEnumerationConstants(returnType);
        }
        Field field = this.getFieldForMethod(method);
        if (field != null && field.getDeclaredAnnotations().length > 0) {
            return this.getFieldAnnotationConstraints(field);
        }
        return null;
    }

    protected String getFieldAnnotationConstraints(Field field) {
        ArrayList<String> constraints = new ArrayList<String>();
        if (field.getAnnotation(Email.class) != null) {
            constraints.add("Email");
        }
        if (field.getAnnotation(Future.class) != null) {
            constraints.add("Future date");
        }
        if (field.getAnnotation(NotNull.class) != null) {
            constraints.add("Not null");
        }
        if (field.getAnnotation(Past.class) != null) {
            constraints.add("Past date");
        }
        if (field.getAnnotation(NotEmpty.class) != null) {
            constraints.add("Not empty");
        }
        if (field.getAnnotation(Pattern.class) != null) {
            constraints.add(String.format("Pattern(regexp = '%s')", field.getAnnotation(Pattern.class).regexp()));
        }
        if (field.getAnnotation(Length.class) != null) {
            constraints.add(String.format("Length(min = %d, max = %d)", field.getAnnotation(Length.class).min(), field.getAnnotation(Length.class).max()));
        }
        if (field.getAnnotation(Size.class) != null) {
            constraints.add(String.format("Size(min = %d, max = %d)", field.getAnnotation(Size.class).min(), field.getAnnotation(Size.class).max()));
        }
        if (field.getAnnotation(Range.class) != null) {
            constraints.add(String.format("Range(min = %d, max = %d)", field.getAnnotation(Range.class).min(), field.getAnnotation(Range.class).max()));
        }
        if (constraints.size() == 0) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        Iterator constraintsIt = constraints.iterator();
        while (constraintsIt.hasNext()) {
            String value = (String)constraintsIt.next();
            buff.append(value);
            if (!constraintsIt.hasNext()) continue;
            buff.append(", ");
        }
        return buff.toString();
    }

    protected String getEnumerationConstants(Class<?> enumeration) {
        ?[] constants = enumeration.getEnumConstants();
        int idx = 0;
        StringBuffer strBuff = new StringBuffer();
        for (Object konst : constants) {
            strBuff.append(konst.toString());
            if (idx < constants.length - 1) {
                strBuff.append(", ");
            }
            ++idx;
        }
        return strBuff.toString();
    }

    protected String getClassType(Method method, List<Class<?>> alsoRead) {
        Field field = this.getFieldForMethod(method);
        if (field == null) {
            return "n/a";
        }
        if (List.class.isAssignableFrom(field.getType())) {
            Type generic = field.getGenericType();
            if (this.listWithSingleGenericType(generic)) {
                Type genericType = ((ParameterizedType)generic).getActualTypeArguments()[0];
                if (!(genericType instanceof Class)) {
                    return "List of T";
                }
                Class genericClass = (Class)genericType;
                if (!this.skipForInspection(genericClass)) {
                    alsoRead.add(genericClass);
                }
                return "List of ".concat(genericClass.getSimpleName());
            }
            return "List";
        }
        if (!this.skipForInspection(method.getReturnType())) {
            alsoRead.add(method.getReturnType());
        }
        return method.getReturnType().getSimpleName();
    }

    protected boolean skipForInspection(Class<?> type) {
        return type.isEnum() || type.isArray() || type.isPrimitive() || type == Integer.class || type == Double.class || type == Byte.class || type == Boolean.class || String.class.isAssignableFrom(type) || type == Long.class || type == Map.class || type == Object.class;
    }

    private boolean listWithSingleGenericType(Type generic) {
        return generic instanceof ParameterizedType && ((ParameterizedType)generic).getActualTypeArguments().length == 1;
    }

    protected String getApiDocFor(Method method) {
        ApiDoc doc = method.getAnnotation(ApiDoc.class);
        if (doc == null) {
            try {
                Field field = this.getFieldForMethod(method);
                if (field != null) {
                    doc = field.getAnnotation(ApiDoc.class);
                }
            }
            catch (Exception ex) {
                LOG.info("Couldn't find field for method: " + method.getName());
            }
        }
        return doc != null ? doc.value() : null;
    }

    protected Field getFieldForMethod(Method method) {
        try {
            String varName = this.toVariableName(method.getName());
            Field field = this.endpointDataClass.getDeclaredField(varName);
            return field;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected boolean bannedMethod(String methodName) {
        return methodName.equals("getClass") || methodName.equals("getMetaClass") || methodName.equals("getProperty");
    }

    protected String toVariableName(String getName) {
        return ("" + getName.charAt(3)).toLowerCase() + getName.substring(4);
    }

    public String getClassName() {
        return this.endpointDataClass.getSimpleName();
    }
}

