/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.syllabus.apidoc;

import java.util.ArrayList;
import java.util.List;
import works.lmz.syllabus.ApiDoc;
import works.lmz.syllabus.apidoc.EndpointData;
import works.lmz.syllabus.events.Event;

public class Endpoint {
    private Class<?> endpoint;
    private Class<?> inputStruct;
    private Class<?> outputStruct;
    private List<EndpointData> inputDataList;
    private List<EndpointData> outputDataList;

    public Endpoint(Class<?> endpoint, Class<?> inputStruct, Class<?> outputStruct) {
        this.endpoint = endpoint;
        this.inputStruct = inputStruct;
        this.outputStruct = outputStruct;
        this.inputDataList = this.getInputDataList();
        this.outputDataList = this.getOutputDataList();
    }

    public String getId() {
        return Integer.toString(this.endpoint.hashCode());
    }

    public String getPurpose() {
        ApiDoc apiDocAnnotation = this.endpoint.getAnnotation(ApiDoc.class);
        if (apiDocAnnotation == null) {
            return null;
        }
        return apiDocAnnotation.value();
    }

    public String getNamespace() {
        Event eventAnnotation = this.endpoint.getAnnotation(Event.class);
        if (eventAnnotation == null) {
            return "n/a";
        }
        return eventAnnotation.namespace();
    }

    public String getName() {
        Event eventAnnotation = this.endpoint.getAnnotation(Event.class);
        if (eventAnnotation == null) {
            return "n/a";
        }
        return eventAnnotation.name();
    }

    public List<EndpointData> getInputDataList() {
        if (this.inputDataList == null) {
            this.inputDataList = new ArrayList<EndpointData>();
            ArrayList alsoRead = new ArrayList();
            if (this.inputStruct != null) {
                alsoRead.add(this.inputStruct);
                while (alsoRead.size() > 0) {
                    Class currentInput = (Class)alsoRead.get(0);
                    alsoRead.remove(0);
                    this.inputDataList.add(new EndpointData(currentInput, alsoRead));
                }
            }
        }
        return this.inputDataList;
    }

    public List<EndpointData> getOutputDataList() {
        if (this.outputDataList == null) {
            this.outputDataList = new ArrayList<EndpointData>();
            ArrayList alsoRead = new ArrayList();
            alsoRead.add(this.outputStruct);
            while (alsoRead.size() > 0) {
                Class currentOutput = (Class)alsoRead.get(0);
                alsoRead.remove(0);
                this.outputDataList.add(new EndpointData(currentOutput, alsoRead));
            }
        }
        return this.outputDataList;
    }
}

