/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.common.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.PostConstruct;
import net.stickycode.configuration.ConfigurationKey;
import net.stickycode.configuration.ConfigurationNotFoundException;
import net.stickycode.configuration.ConfigurationSource;
import net.stickycode.configuration.ConfigurationValue;
import net.stickycode.configuration.ResolvedConfiguration;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarManifestConfigurationSource
implements ConfigurationSource {
    private static final Logger logger = LoggerFactory.getLogger(JarManifestConfigurationSource.class);
    public static final String KEY_IMPLEMENTATION_VERSION = Attributes.Name.IMPLEMENTATION_VERSION.toString();
    private Manifest manifest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public boolean loadManifest() {
        if (this.manifest != null) {
            return true;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream stream = null;
        try {
            stream = loader.getResourceAsStream("META-INF/MANIFEST.MF");
            this.manifest = new Manifest(stream);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.warn("An error occurred while loading the manifest: {}", (Object)e.getMessage());
            this.manifest = null;
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    public boolean hasValue(String key) {
        return this.loadManifest() && this.manifest.getMainAttributes().containsKey(key);
    }

    public String getValue(String key) throws ConfigurationNotFoundException {
        if (this.manifest == null) {
            throw new ConfigurationNotFoundException(key);
        }
        String value = this.manifest.getMainAttributes().getValue(key);
        if (value == null) {
            throw new ConfigurationNotFoundException(key);
        }
        return value;
    }

    public void apply(ConfigurationKey key, ResolvedConfiguration values) {
        String configKey = key.join(".");
        if (configKey.contains(".")) {
            return;
        }
        if (this.manifest == null) {
            return;
        }
        final String value = this.manifest.getMainAttributes().getValue(configKey);
        if (value != null) {
            values.add(new ConfigurationValue(){

                public String get() {
                    return value;
                }

                public boolean hasPrecedence(ConfigurationValue v) {
                    return true;
                }
            });
        }
    }
}

